package WebInterface;

use qbit;

use base qw(QBit::WebInterface::FastCGI WebInterface::HTTPS Application);

use YAML::Syck;

use Yandex::Utils;
use Yandex::SecretKey;
use QBit::WebInterface::FastCGI::ShortLinkRequest;

use QBit::WebInterface::Controller::BEMHTML;

use WebInterface::Controller::RBAC path                    => 'rbac';
use WebInterface::Controller::MainPage path                => 'main';
use WebInterface::Controller::Settings path                => 'settings';
use WebInterface::Controller::Dashboard path               => 'dashboard', tab => 'dashboard';
use WebInterface::Controller::Log path                     => 'log';
use WebInterface::Controller::Queue path                   => 'queue';
use WebInterface::Controller::Queue::UpdateStatistics path => 'queue_update_statistics';

use WebInterface::Controller::Domain path => 'domain', tab => 'traffsrc';
use WebInterface::Controller::ShortLink path => 's';

use WebInterface::Controller::Product path => 'product', tab => 'products';

use WebInterface::Controller::Product::InternalAN::InternalContextOnSite::Campaign
  path => 'internal_context_on_site_campaign',
  tab  => 'products';
use WebInterface::Controller::Product::InternalAN::InternalContextOnSite::Direct
  path => 'internal_context_on_site_direct',
  tab  => 'products';
use WebInterface::Controller::Product::InternalAN::InternalContextOnSite::Stripe
  path => 'internal_context_on_site_stripe',
  tab  => 'products';
use WebInterface::Controller::Product::InternalAN::InternalSearchOnSite::Campaign
  path => 'internal_search_on_site_campaign',
  tab  => 'products';
use WebInterface::Controller::Product::InternalAN::InternalSearchOnSite::Direct
  path => 'internal_search_on_site_direct',
  tab  => 'products';
use WebInterface::Controller::Product::InternalAN::InternalSearchOnSite::Premium
  path => 'internal_search_on_site_premium',
  tab  => 'products';
use WebInterface::Controller::Product::InternalAN::MobileApp path => 'internal_mobile_app', tab => 'products';
use WebInterface::Controller::Product::InternalAN::MobileApp::RTB path => 'internal_mobile_app_rtb';

use WebInterface::Controller::Product::AN::MobileApp::MobileApp path => 'mobile_app';
use WebInterface::Controller::Product::AN::MobileApp::RTB path       => 'mobile_app_rtb';

use WebInterface::Controller::Product::AN::Site path            => 'site';
use WebInterface::Controller::Product::AN::Site::OwnerSite path => 'owner_site';

use WebInterface::Controller::Product::AN::SearchOnSite::Campaign
  path => 'search_on_site_campaign',
  tab  => 'products';
use WebInterface::Controller::Product::AN::SearchOnSite::Direct
  path => 'search_on_site_direct',
  tab  => 'products';
use WebInterface::Controller::Product::AN::SearchOnSite::Premium
  path => 'search_on_site_premium',
  tab  => 'products';

use WebInterface::Controller::Product::AN::ContextOnSite::Campaign
  path => 'context_on_site_campaign',
  tab  => 'products';
use WebInterface::Controller::Product::AN::ContextOnSite::RTB
  path => 'context_on_site_rtb',
  tab  => 'products';
use WebInterface::Controller::Product::AN::ContextOnSite::Direct
  path => 'context_on_site_direct',
  tab  => 'products';
use WebInterface::Controller::Product::AN::ContextOnSite::Stripe
  path => 'context_on_site_stripe',
  tab  => 'products';

use WebInterface::Controller::Product::VideoAN::Site path        => 'video_an_site';
use WebInterface::Controller::Product::VideoAN::Site::Video path => 'video_an_site_block';

use WebInterface::Controller::Inviter path => 'inviter', tab => 'tools';
use WebInterface::Controller::Users path   => 'users',   tab => 'tools';
use WebInterface::Controller::News path    => 'news',    tab => 'tools';

use WebInterface::Controller::Kladr path => 'kladr';
use WebInterface::Controller::Banks path => 'banks';

use WebInterface::Controller::Devel path => 'devel', tab => 'devtools';

use WebInterface::Controller::Utils path => 'utils';

use WebInterface::Controller::DSP path => 'dsp', tab => 'dsp';

use WebInterface::Controller::TNSDict path => 'tns_dict';

use Exception::BlackBox::NeedAuth;
use Exception::BlackBox::NeedRealLogin;
use Exception::BlackBox::NeedResign;
use Exception::BlackBox::NotSecure;

use PiConstants qw($AUTHORIZATION_USER_FIELDS $BLACKBOX_DBFIELDS);

sub default_cmd {main => 'page'}

sub get_passport_host {
    my ($self) = @_;

    return $self->api_blackbox->_get_addr_pass($self->request->server_name)->{'host_passport'};
}

sub get_registered_right_groups {
    my ($self) = @_;

    require API;
    my $res = API->new()->get_registered_right_groups();
    push_hs($res, $self->SUPER::get_registered_right_groups());

    return $res;
}

sub get_registered_rights {
    my ($self) = @_;

    require API;
    my $res = API->new()->get_registered_rights();
    push_hs($res, $self->SUPER::get_registered_rights());

    return $res;
}

sub init {
    my ($self) = @_;

    $self->use_config('WebInterface.json');

    $self->SUPER::init();

    local $self->{'__OPTIONS__'} = clone($self->{'__ORIG_OPTIONS__'});

    QBit::WebInterface::Controller::BEMHTML::_create_v8_context_if_required($self);
}

sub post_cmd {
    my ($self) = @_;

    $self->response->headers->{'X-Yandex-Login'} = $self->get_option(cur_user => {})->{login} // '';
    if ($self->request->uri !~ m|^/widget/statistics|) {
        $self->response->headers->{'X-Frame-Options'} = 'Deny';
    }
}

sub pre_cmd {
    my ($self, $controller) = @_;

    $ENV{SYSTEM} = 'webinterface';

    # Вдруг остался от предыдущего раза
    $self->set_cur_user(undef);

    delete $self->{'__REQUEST_ID__'};

    # get data from BB
    my $bb_res;
    try {
        $bb_res = $self->api_blackbox->sessionid(
            session_id     => $self->request->cookie('Session_id'),
            sessionid2     => $self->request->cookie('sessionid2'),
            remote_addr    => $self->request->remote_addr(),
            server_name    => $self->request->server_name(),
            fields         => $BLACKBOX_DBFIELDS,
            must_be_secure => TRUE,
        );
    }
    catch Exception::BlackBox::NeedAuth with {
        $bb_res = 0;
    }
    catch Exception::BlackBox::NotSecure with {
        my ($e) = @_;

        $bb_res = 0;

        # Если нет куки sessionid2 или она не валидна,
        # то разлогиниваем пользователя

        my $passport_host = $e->{host_passport};

        my $passport_logout_url =
            "https://$passport_host/passport?mode=logout&from=pi&yu="
          . uri_escape($controller->request->cookie('yandexuid'))
          . "&retpath="
          . uri_escape($controller->request->url());

        return $self->break($controller->redirect2url($passport_logout_url));
    }
    catch Exception::BlackBox::NeedResign with {
        my ($self) = @_;
        if ($self->{res} && $controller->request->method eq 'POST') {
            $bb_res = $self->{res};
        } else {
            $bb_res = {
                redirect => $self->{url_resign}
                  . "retpath="
                  . uri_escape($controller->_get_url_absolute($controller->request->uri())),
                cookeis => $self->{cookies},
            };
        }
    }
    catch Exception::BlackBox::NeedRealLogin with {
        my ($self) = @_;
        $bb_res =
          {     redirect => $self->{url_auth}
              . "mode=postregistration&create_login=1&from=pi&retpath="
              . uri_escape($controller->_get_url_absolute($controller->request->param('retpath', ''))),};
    };

    $bb_res = 0 if ($self->request->param('nocookiesupport'));

    my $cur_user = undef;
    if ($bb_res == 0) {
        # Оставляем cur_user = undef
    } elsif ($bb_res->{redirect}) {
        $controller->response->add_cookie(%{$bb_res->{cookeis}}) if ($bb_res->{cookeis});
        return $self->break($controller->redirect2url($bb_res->{redirect}));
    } else {
        {

            if ($self->request->scheme() eq 'http') {
                return $self->break($controller->redirect2url($self->get_https_url()));
            }

            my $tmp_rights =
              $self->add_tmp_rights(qw(users_view_all users_view_field__multistate users_view_field__client_id));
            unless ($cur_user =
                $self->users->get_by_uid($bb_res->{'uid'}{'content'}, fields => $AUTHORIZATION_USER_FIELDS))
            {
                $cur_user = {
                    blackbox      => TRUE,
                    id            => $bb_res->{'uid'}{'content'},
                    login         => $bb_res->{'dbfield'}{'accounts.login.uid'},
                    language      => $bb_res->{'dbfield'}{'userinfo.lang.uid'},
                    email         => $bb_res->{'address-list'}->{'address'}->{content},
                    business_unit => 0,
                };
                ($cur_user->{'lastname'}, $cur_user->{'name'}, $cur_user->{'midname'}) =
                  (split(' ', $bb_res->{'dbfield'}{'account_info.fio.uid'} || ''), '', '', '');
            }
            $cur_user->{'display_login'} = $bb_res->{'login'}{'content'};
        }
    }
    # <<< get data from BB <<<

    # Ставим метку в паспорте для зарегестрированных логинов
    if (   $cur_user
        && !$cur_user->{'blackbox'}
        && $bb_res
        && !$bb_res->{'dbfield'}{'subscription.suid.85'}
        && $self->get_option('sign_user_in_passport'))
    {
        $self->api_passport->admsubscribe(uid => $cur_user->{'id'}, from => 'pi');
    }

    $self->set_cur_user($cur_user);

    # Если нет права, то игнорируем установку в конфиге
    $self->set_option(fake_login => $self->check_rights('fake_login'))
      if $self->get_option('allow_fake_login');

    if ($self->get_option('fake_login') && $self->request->cookie('fakelogin')) {
        my $fake_user =
          $self->users->get_by_login($self->request->cookie('fakelogin'), fields => $AUTHORIZATION_USER_FIELDS)
          // throw gettext('Bad fake login');
        $fake_user->{'display_login'} = $fake_user->{'login'};
        $fake_user->{'fake'}          = TRUE;
        $fake_user->{'real_user'}     = $cur_user;
        $cur_user                     = $fake_user;
    }

    $self->set_cur_user($cur_user);

    my ($user_is_logged, $user_is_in_db);

    if ($self->get_option('cur_user')) {
        $user_is_logged = TRUE;
        $user_is_in_db  = !$self->get_option('cur_user')->{'blackbox'};
    }

    my $user_is_yandex = $user_is_logged && ($cur_user->{'login'} =~ /^yndx[\.-]/ || $self->check_rights('yndx_login'));

    my $page_is_yan_main          = $self->_is_cmd_path('yan',               'main');
    my $page_is_contract_form     = $self->_is_cmd_path('contract_form',     'settings');
    my $page_is_banner_store_form = $self->_is_cmd_path('banner_store_form', 'settings');
    my $page_is_accept_inviter    = $self->_is_cmd_path('accept',            'inviter')
      || $self->_is_cmd_path('auto_accept_mobile', 'inviter');
    my $page_is_contacts_settings       = $self->_is_cmd_path('contacts',        'settings');
    my $page_is_contract_settings       = $self->_is_cmd_path('contract',        'settings');
    my $page_is_create_contact_settings = $self->_is_cmd_path('create_contract', 'settings');
    my $page_is_login                   = $self->_is_cmd_path('login',           'main');
    my $page_is_logout                  = $self->_is_cmd_path('logout',          'main');
    my $page_is_fake_logout             = $self->_is_cmd_path('fake_logout',     'main');
    my $page_is_kladr = $self->get_option('cur_cmdpath') eq 'kladr';
    my $page_is_banks = $self->get_option('cur_cmdpath') eq 'banks';
    my $page_is_person =
      (($self->get_option('cur_cmdpath') eq 'person') or $self->_is_cmd_path('create_person', 'settings'));

    if ($controller->attrs()->{'WOAUTH'} && !($user_is_yandex && $self->_page_is_default())) {
        # Пользователь всегда имеет доступ к этим страницам
    } elsif ($user_is_logged && $user_is_yandex) {

    } elsif ($user_is_logged && !$user_is_yandex) {

        if ($user_is_in_db) {

            if (   $page_is_logout
                || $page_is_fake_logout
                || $page_is_accept_inviter
                || $page_is_contacts_settings
                || $page_is_contract_settings
                || $page_is_person
                || $page_is_create_contact_settings)
            {
                # Пользователь всегда имеет доступ к этим страницам
            } elsif ($self->users->check_action($cur_user->{id}, 'created_partner_in_banner_store')
                && !$page_is_banner_store_form)
            {
                return $self->break($controller->redirect('banner_store_form', path => 'settings'));
            } elsif ($self->users->check_action($cur_user->{id}, 'created_partner_in_banner_store')
                && $page_is_banner_store_form)
            {
                # Даём пользователю создать профиль в Banner store.
                # Иначе если у пользователя две роли, то бесконечные редиректы...
            } elsif ($self->users->check_action($cur_user->{id}, 'yan_contract_ready')
                && !$page_is_contract_form
                && !$page_is_kladr
                && !$page_is_banks)
            {
                return $self->break($controller->redirect2url_internal('/settings/contract?type=yan'));
            }

        } else {

            if ($page_is_yan_main) {
                return $self->break(
                    $controller->redirect('contacts', path => 'settings', retpath => $self->request->uri()));
            } elsif ($page_is_login
                || $page_is_logout
                || $page_is_contacts_settings
                || $page_is_accept_inviter)
            {
                # Пользователи которых нет в таблице users имеет доступ к этим
                # страницам
            } else {
                return $self->break($controller->denied());
            }

        }

    } elsif (!$user_is_logged) {
        return $self->break($controller->redirect('login', path => 'main', retpath => $self->request->uri()));
    } else {
        throw "Error in code. This should never happen.";
    }

=begin comment Определяем язык и регион пользователя

Если не фейк логин, а обыкновыенный пользователь, то определяем язык с помощью
библиотеки lang-detect.

Если же это fake user, то спрашиваем паспорт о настройке языке этого
пользвателя. Если пользователь зашел бы на сайт, то возможно он получил бы
сайт на другом языке (например из-за домена на который он пришел или из-за
региона или еще из-за каких-то параметров, на основании которых работает
lang-detect), но поскольку у нас нет этих данных, то показываем язык
основываясь только на настройке паспорта.

=end comment

=cut

    my $user_lang;
    my $reg;

    if ($cur_user->{'fake'}) {
        $user_lang = $self->get_user_lang($cur_user->{'real_user'}{'id'});
        $cur_user->{'fake_locale'} = $self->get_user_lang($cur_user->{'id'});
    } else {
        my $regions = $self->api_geobase->get_cached_region_parents(ip => $self->request->remote_addr());
        $user_lang = $self->lang_detect->get_user_lang(
            regions         => $regions,
            supported       => [sort keys(%{$self->get_option('locales')})],
            accept_language => $self->request->http_header('Accept-Language'),
            host            => $self->request->server_name,
            cookie          => $self->request->cookie('my'),
            default         => 'ru',
        );

        my $domain_region = $self->lang_detect->get_domain_region(
            regions   => $regions,
            supported => [sort keys(%{$self->get_option('locales')})],
            host      => $self->request->server_name,
        )->{'domain'};
        ($reg) = $domain_region =~ /(?:.*?)\.(ru|ua|by|com|kz|tr)$/;
    }

    $self->set_option(content_region => $reg);

    $self->set_app_locale($user_lang);

    $self->set_option(
        secret_key => $self->get_option('cur_user')
        ? get_auth_secretkey($cur_user->{fake} ? $cur_user->{'real_user'}{'id'} : $cur_user->{id})
        : get_not_auth_secretkey($controller->request->cookie('yandexuid'))
    );

    $self->set_option(yandex_domain => get_yandex_domain($self->request->url));

}

sub pre_run {
    my ($self) = @_;

    $self->SUPER::pre_run();

    my ($path, $cmd) = $self->get_cmd();
    if ($path eq 's' && defined($cmd) && $cmd ne 'add') {
        my $request_data = $self->short_link->get($cmd) // return FALSE;

        $self->request(
            QBit::WebInterface::FastCGI::ShortLinkRequest->new(
                request => $self->request->{'request'},
                %$request_data
            )
        );
    }

    return FALSE;
}

sub process_mem_cycles {
    my ($self, @data) = @_;

    my $text = $self->SUPER::process_mem_cycles(@data);

    if ($self->response->content_type =~ /text\/html/ && $text) {
        my $html = $text;
        for ($html) {
            s/ /&nbsp;/g;
            s/\r|\n|\r\n/<br>/g;
        }
        $html = "<div style=\"background-color: #ffcccc; padding: 10px;\"><code>$html</code></div>";
        (
            ref($self->response->{'data'}) eq 'SCALAR'
            ? ${$self->response->{'data'}}
            : $self->response->{'data'}
        ) =~ s/(<body.*?>)/$1$html/;
    }

    return $text;
}

sub _format2html {
    my ($opts) = @_;

    my ($start, $end) = ('', '');

    if (defined($opts->{'color'}) && $opts->{'color'} =~ /^[#0-9a-zA-Z]+$/) {
        $start .= "<font color=\"$opts->{'color'}\">";
        $end = "</font>$end";
    }

    if ($opts->{'bold'}) {
        $start .= "<strong>";
        $end = "</strong>$end";
    }

    if ($opts->{'italic'}) {
        $start .= "<i>";
        $end = "</i>$end";
    }

    return [$start, $end];
}

sub _is_cmd_path {
    my ($self, $cmd, $path) = @_;

    return $self->get_option('cur_cmd') eq $cmd && $self->get_option('cur_cmdpath') eq $path;
}

sub _mark_active_path_in_menu {
    my ($self, $items) = (@_);

    my $deleted = $self->request->param('deleted');
    my $cmds    = $self->get_cmds();

    my @path_cmd_synonyms = ([$self->get_cmd()], [$self->get_option('cur_cmdpath'), $self->get_option('cur_cmd')]);

    my @uri_synonyms = map {
        my ($path, $cmd) = @$_;

        my @uri_synonyms = ();
        if (defined($path) && length($path)) {
            if (defined($cmd) && length($cmd)) {
                push(@uri_synonyms, "/$path/$cmd", "/$path/$cmd/");
                push(@uri_synonyms, "/$path/",     "/$path")
                  if exists($cmds->{$path}->{'__DEFAULT__'})
                      && exists($cmds->{$path}->{'__DEFAULT__'}->{'name'})
                      && $cmds->{$path}->{'__DEFAULT__'}->{'name'} eq $cmd;
            } else {
                push(@uri_synonyms, "/$path/", "/$path");
            }
        } else {
            push(@uri_synonyms, '/');
        }

        if ($deleted) {
            $_ .= '?deleted=1' foreach @uri_synonyms;
        }

        @uri_synonyms;
    } @path_cmd_synonyms;

    unshift(@uri_synonyms, $self->request->uri) if $self->request->uri =~ /\?/;

    push(@uri_synonyms, '/') if $self->_page_is_default();

    my $active_marked = FALSE;
    foreach my $uri (@uri_synonyms) {
        $active_marked = $self->_mark_active_path_in_menu_iterator($uri, $items);
        last if $active_marked;
    }
    return $active_marked;
}

sub _mark_active_path_in_menu_iterator {
    my ($self, $url, $items) = @_;

    my $active_marked = FALSE;
    foreach my $item (@$items) {

        $active_marked = $self->_mark_active_path_in_menu_iterator($url, $item->{'items'}) if exists($item->{'items'});
        $active_marked = TRUE if exists($item->{'url'}) && $item->{'url'} eq $url;

        if ($active_marked) {
            $item->{'active'} = TRUE + 0;
            last;
        }
    }

    return $active_marked;
}

sub _menu {
    my ($self, $controller) = @_;

    my $page_is_accept_inviter = $self->_is_cmd_path('accept', 'inviter')
      || $self->_is_cmd_path('auto_accept_mobile', 'inviter');
    my $page_is_contract_settings = $self->_is_cmd_path('contract', 'settings');
    my $page_is_person =
      (($self->get_option('cur_cmdpath') eq 'person') or $self->_is_cmd_path('create_person', 'settings'));

    my $no_menu = !$self->get_option('cur_user')
      || (($page_is_contract_settings || $page_is_person)
        && $self->users->check_action($self->get_option('cur_user')->{'id'}, 'fill_distr_contract_mandatory'))
      || $page_is_accept_inviter;

    if ($no_menu) {
        $self->set_option(menu => []);
        return FALSE;
    }

    my @items = ();

    my $cur_user = $self->get_option('cur_user', {blackbox => TRUE});

    my $resources = $self->resources->get_get_resources();
    $self->set_option(resources => $resources);

    foreach my $item_name (qw(products statistics)) {
        my $sub_name = "_menu__$item_name";
        my ($tab) = $self->$sub_name($controller, $resources);
        next unless $tab;
        push(@items, $tab);
    }

    my @down_items = ();
    push(
        @down_items,
        {
            type => 'item',
            name => gettext('Inviter'),
            url  => '/v2/inviter/'
        }
    ) if $self->check_rights('inviter_view');

    push(
        @down_items,
        {
            type => 'item',
            name => gettext('Users'),
            url  => $self->make_cmd(list => 'users')
        }
    ) if $self->check_rights('users_view');

    push(
        @down_items,
        {
            type => 'item',
            name => gettext('Financial documents'),
            url  => '/v2/financial/acts/'
        }
    ) if $self->check_rights('partner_acts_view');

    push(
        @down_items,
        {
            type => 'item',
            name => gettext('News'),
            url  => $self->make_cmd(list => 'news')
        }
    ) if $self->check_rights('news_list_view');

    #menu for devtools
    my @devtools_menu = $self->_menu__devtools($controller, $resources);
    push(@down_items, @devtools_menu) if @devtools_menu;

    push(
        @down_items,
        {
            type => 'item',
            name => gettext('Cookie Match'),
            url  => '/v2/cookie-matching/'
        }
    ) if $self->check_rights('cookie_match_view');

    push(
        @down_items,
        {
            type => 'item',
            name => gettext('Moderation'),
            url  => '/v2/moderation/'
        }
    ) if $self->check_rights('moderation_view');

    push(@items, {type => 'separator'}, @down_items) if @down_items;

    unshift(
        @items,
        {
            type => 'item',
            url  => '/'
        }
    ) if @items;

    $self->_mark_active_path_in_menu(\@items);

    $self->set_option(menu => \@items);
}

sub _menu__devtools {
    my ($self, $controller, $resources) = @_;

    return () if $self->get_option('cur_user', {blackbox => TRUE})->{'blackbox'};

    my @items;

    ####################################################################################################################
    # Information
    ####################################################################################################################
    {
        my @info;

        push(
            @info,
            {
                type => 'item',
                name => gettext('Mails'),
                url  => $self->make_cmd(view_mail => 'devel'),
            }
        ) if $self->check_rights('mailer_view');

        push(
            @info,
            {
                type => 'item',
                name => gettext('Cron jobs'),
                url  => $self->make_cmd(cron_jobs => 'devel'),
            }
        ) if $self->check_rights('view_cron_job');

        push(
            @info,
            {
                type => 'item',
                name => gettext('Queue'),
                url  => '/v2/queue/list'
            }
        ) if $self->check_rights('queue_view');

        push(
            @items,
            {
                type  => 'group',
                name  => gettext('Information'),
                url   => $info[0]->{'url'},
                items => \@info,
            }
        ) if @info;
    }

    ####################################################################################################################
    # Management
    ####################################################################################################################
    {
        my @management;

        push(
            @management,
            {
                type => 'item',
                name => gettext('Text templates'),
                url  => $self->make_cmd(text_template_list => 'devel'),
            }
        ) if $self->check_rights('text_template_view');

        push(
            @management,
            {
                type => 'item',
                name => gettext('Internal API ACLs'),
                url  => $self->make_cmd(intapi_acl_list => 'devel'),
            }
        ) if $self->check_rights('intapi_acl_view');

        push(
            @management,
            {
                type => 'item',
                name => gettext('Simple notification'),
                url  => $self->make_cmd(simple_notification_list => 'devel'),
            }
        ) if $self->check_rights('simple_notification_tool');

        push(
            @management,
            {
                type => 'item',
                name => gettext('Notification'),
                url  => $self->make_cmd(notification_list => 'devel'),
            }
        ) if $self->check_rights('notification_tool');

        push(
            @management,
            {
                type => 'item',
                name => gettext('moderation_reason'),
                url  => $self->make_cmd(moderation_reason_list => 'devel'),
            }
        ) if $self->check_rights('moderation_reason_tool');

        push(
            @management,
            {
                type => 'item',
                name => gettext('Add additional income'),
                url  => $self->make_cmd(insert_additional_income_stat => 'devel'),
            }
        ) if $self->check_rights('devel_insert_additional_income_stat');

        push(
            @management,
            {
                type => 'item',
                name => gettext('Support queue task'),
                url  => '/v2/queue/list',
            }
        ) if $self->check_rights('queue_support_task');

        push(
            @management,
            {
                type => 'item',
                name => gettext('custom_bk_options'),
                url  => $self->make_cmd(custom_bk_options_list => 'devel'),
            }
        ) if $self->check_rights('custom_bk_options_edit');

        push(
            @items,
            {
                type  => 'group',
                name  => gettext('Management'),
                url   => $management[0]->{'url'},
                items => \@management,
            }
        ) if @management;

    }

    ####################################################################################################################
    # Баланс
    ####################################################################################################################
    {
        my @devtools_balance;

        push(
            @devtools_balance,
            {
                type => 'item',
                name => gettext('Drop user'),
                url  => $self->make_cmd(drop_user => 'devel'),
            }
        ) if $resources->{'devel_drop_user'};

        push(
            @devtools_balance,
            {
                type => 'item',
                name => gettext('Create client'),
                url  => $self->make_cmd(create_client => 'devel'),
            }
        ) if $resources->{'devel_create_client'};

        push(
            @devtools_balance,
            {
                type => 'item',
                name => gettext('Remove user client association'),
                url  => $self->make_cmd(remove_user_client_association => 'devel'),
            }
        ) if $resources->{'devel_remove_user_client_association'};

        push(
            @devtools_balance,
            {
                type => 'item',
                name => gettext('CreateOrUpdatePlace switch'),
                url  => $self->make_cmd(create_or_update_place_switch => 'devel'),
            }
        ) if $resources->{'devel_create_or_update_place_switch'};

        push(
            @items,
            {
                type  => 'group',
                name  => gettext('Balance'),
                url   => $devtools_balance[0]->{'url'},
                items => \@devtools_balance,
            }
        ) if @devtools_balance;
    }

    ####################################################################################################################
    # БК
    ####################################################################################################################
    {
        my @devtools_bk;

        push(
            @devtools_bk,
            {
                type => 'item',
                name => gettext('BK PI comparison'),
                url  => $self->make_cmd(bk_pi_comparison => 'devel'),
            }
        ) if $self->check_rights('devel_bk_pi_comparison');

        push(
            @devtools_bk,
            {
                type => 'item',
                name => gettext('View BK send log'),
                url  => $self->make_cmd(bk_send_log => 'devel'),
            }
        ) if $self->check_rights('bk_edit_page_view_bk_send_log');

        push(
            @devtools_bk,
            {
                type => 'item',
                name => gettext('Update options on Page'),
                url  => $self->make_cmd(update_options => 'devel'),
            }
        ) if $self->check_rights('devel_update_options');

        push(
            @items,
            {
                type  => 'group',
                name  => gettext('BK'),
                url   => $devtools_bk[0]->{'url'},
                items => \@devtools_bk,
            }
        ) if @devtools_bk;
    }

    ####################################################################################################################
    # Test tools
    ####################################################################################################################
    {
        my @test_tools;

        push(
            @test_tools,
            {
                type => 'item',
                name => gettext('Check fields'),
                url  => $self->make_cmd(fields => 'devel'),
            }
        ) if $self->check_rights('view_check_fields');

        push(
            @test_tools,
            {
                type => 'item',
                name => gettext('Check work with Yandex.Money'),
                url  => $self->make_cmd(test_yamoney => 'devel'),
            }
        ) if $self->check_rights('devel_test_yamoney');

        push(
            @items,
            {
                type  => 'group',
                name  => pgettext('Menu', 'Test'),
                url   => $test_tools[0]->{'url'},
                items => \@test_tools,
            }
        ) if @test_tools;

    }

    ###
    return @items
      ? {
        type  => 'group',
        name  => gettext('Dev tools'),
        url   => $items[0]->{'url'},
        items => \@items
      }
      : ();
}

sub _menu__products {
    my ($self, $controller, $resources) = @_;

    my $deleted = $self->request->param('deleted');

    my @items;

    my @an = ();

    # Сайты
    if ($resources->{'site'}) {
        push(@an, {type => 'item', name => gettext('Sites'), url => '/v2/sites/'});
    }

    # Тематические площадки
    my @an_context;

    if ($resources->{'context_on_site_rtb'}) {
        push(@an_context, {type => 'item', name => gettext('RTB-blocks'), url => '/v2/context/rtb/'});
    }

    if ($resources->{'context_on_site_direct'}) {
        push(@an_context, {type => 'item', name => gettext('Direct-blocks'), url => '/v2/context/direct/'});
    }

    if ($resources->{'context_on_site_stripe'}) {
        push(@an_context, {type => 'item', name => gettext('Promo-block'), url => '/v2/context/stripe/'});
    }

    if ($resources->{'context_on_site_adblock'}) {
        push(@an_context, {type => 'item', name => gettext('ADBLOCK-blocks'), url => '/v2/context/adblock/'});
    }

    if (@an_context) {
        push(@an, {type => 'item', name => gettext('Thematic campaigns'), url => '/v2/context/campaigns/'});
        push(@an, {type => "sub-group", items => \@an_context});
    }

    # Поисковые площадки
    my @an_search;

    if ($resources->{'search_on_site_premium'}) {
        push(@an_search, {type => 'item', name => gettext('Premium Placement'), url => '/v2/search/premium/'});
    }

    if ($resources->{'search_on_site_direct'}) {
        push(@an_search, {type => 'item', name => gettext('Search Direct'), url => '/v2/search/direct/'});
    }

    if (@an_search) {
        push(@an, {type => 'item', name => gettext('Search campaigns'), url => '/v2/search/campaigns/'});
        push(@an, {type => "sub-group", items => \@an_search});
    }

    # РЕКЛАМА НА САЙТАХ
    if (@an) {
        push(@items, {type => 'group', name => gettext('Ad on sites'), url => $an[0]->{'url'}, items => \@an});
    }

    # РЕКЛАМА В ПРИЛОЖЕНИЯХ
    my @mobile_an = ();

    if ($resources->{'mobile_app'}) {
        push(@mobile_an, {type => 'item', name => gettext('Applications'), url => '/v2/mobile/applications/'});
    }

    if ($resources->{'mobile_app_settings'}) {
        push(@mobile_an, {type => 'item', name => gettext('Settings'), url => '/v2/mobile/campaigns/'});
    }

    if ($resources->{'mobile_app_rtb'}) {
        push(
            @mobile_an,
            {
                type  => 'sub-group',
                items => [{type => 'item', name => gettext('Mobile RTB-blocks'), url => '/v2/mobile/rtb/'}]
            }
        );
    }

    if (@mobile_an) {
        push(@items,
            {type => 'group', name => gettext('Ads in apps'), url => $mobile_an[0]->{'url'}, items => \@mobile_an});
    }

    # РЕКЛАМА В ВИДЕО
    my @an_video = ();

    if ($resources->{'video_an_site'}) {
        push(@an_video, {type => 'item', name => gettext('Video Resources'), url => '/v2/video/sites/'});
    }

    if ($resources->{'video_an_site_instream'}) {
        push(
            @an_video,
            {
                type  => 'sub-group',
                items => [{type => 'item', name => gettext('Instream blocks'), url => '/v2/video/instream/'}]
            }
        );
    }

    if ($resources->{'video_an_site_inpage'}) {
        push(
            @an_video,
            {
                type  => 'sub-group',
                items => [{type => 'item', name => gettext('InPage blocks'), url => '/v2/video/inpage/'}]
            }
        );
    }

    if ($resources->{'video_an_site_fullscreen'}) {
        push(
            @an_video,
            {
                type  => 'sub-group',
                items => [{type => 'item', name => gettext('Fullscreen blocks'), url => '/v2/video/fullscreen/'}]
            }
        );
    }

    if ($resources->{'partner_content'}) {
        push(@an_video, {type => 'item', name => gettext('Category'), url => '/v2/video/reference/content/'});
    }

    if (@an_video) {
        push(@items,
            {type => 'group', name => gettext('AD in video'), url => $an_video[0]->{'url'}, items => \@an_video});
    }

    # СЕРВИСЫ ЯНДЕКСА
    my @an_internal;

    if ($resources->{'internal_context_on_site_campaign'}) {
        push(@an_internal,
            {type => 'item', name => gettext('Thematic platforms'), url => '/v2/internal/context/campaigns/'});
    }

    my @an_internal_context;

    if ($resources->{'internal_context_on_site_content'}) {
        push(@an_internal_context,
            {type => 'item', name => gettext('Content-blocks'), url => '/v2/internal/context/content/'});
    }

    if ($resources->{'internal_context_on_site_rtb'}) {
        push(@an_internal_context, {type => 'item', name => gettext('RTB-blocks'), url => '/v2/internal/context/rtb/'});
    }

    if ($resources->{'internal_context_on_site_direct'}) {
        push(@an_internal_context,
            {type => 'item', name => gettext('Direct-blocks'), url => '/v2/internal/context/direct/'});
    }

    if ($resources->{'internal_context_on_site_stripe'}) {
        push(
            @an_internal_context,
            {
                type  => 'group',
                name  => gettext('Promo-block'),
                url   => '/internal_context_on_site_stripe/list/',
                items => [
                    {
                        type => 'item',
                        name => gettext('Promo-block'),
                        url  => '/internal_context_on_site_stripe/list/',
                    },
                    (
                        $resources->{'internal_context_on_site_stripe_deleted'}
                        ? {
                            type => 'item',
                            name => gettext('Deleted items'),
                            url  => '/internal_context_on_site_stripe/list/?deleted=1',
                          }
                        : ()

                    ),

                ]
            },
        );
    }

    if (@an_internal_context) {
        push(@an_internal, {type => 'sub-group', items => \@an_internal_context});
    }

    if ($resources->{'internal_search_on_site_campaign'}) {
        push(
            @an_internal,
            {
                type  => 'group',
                name  => gettext('Search ad platforms'),
                url   => '/v2/internal/search/campaigns/',
                items => [
                    {
                        type => 'item',
                        name => gettext('Search ad platforms'),
                        url  => '/v2/internal/search/campaigns/',
                    },
                    (
                        $resources->{'internal_search_on_site_campaign_deleted'}
                        ? {
                            type => 'item',
                            name => gettext('Deleted items'),
                            url  => '/v2/internal/search/campaigns/archive/'
                          }
                        : (),
                    ),
                ],
            },
        );
    }

    my @an_internal_search;

    if ($resources->{'internal_search_on_site_premium'}) {
        push(
            @an_internal_search,
            {
                type  => 'group',
                name  => gettext('Premium Placement'),
                url   => '/internal_search_on_site_premium/list/',
                items => [
                    {
                        type => 'item',
                        name => gettext('Premium Placement'),
                        url  => '/internal_search_on_site_premium/list/',
                    },
                    (
                        $resources->{'internal_search_on_site_premium_deleted'}
                        ? {
                            type => 'item',
                            name => gettext('Deleted items'),
                            url  => '/internal_search_on_site_premium/list/?deleted=1',

                          }
                        : ()
                    ),
                ],
            }
        );
    }

    if ($resources->{'internal_search_on_site_direct'}) {
        push(
            @an_internal_search,
            {
                type  => 'group',
                name  => gettext('Search Direct'),
                url   => '/internal_search_on_site_direct/list/',
                items => [
                    {
                        type => 'item',
                        name => gettext('Search Direct'),
                        url  => '/internal_search_on_site_direct/list/',
                    },
                    (
                        $resources->{'internal_search_on_site_direct_deleted'}
                        ? {
                            type => 'item',
                            name => gettext('Deleted items'),
                            url  => '/internal_search_on_site_direct/list/?deleted=1',
                          }
                        : ()
                    ),

                ],
            }
        );
    }

    if (@an_internal_search) {
        push(@an_internal, {type => 'sub-group', items => \@an_internal_search});
    }

    if ($resources->{'internal_mobile_app'}) {
        push(@an_internal,
            {type => 'item', name => gettext('Internal Applications'), url => '/v2/internal/mobile/applications/'});
    }

    my @an_internal_mobile;

    if ($resources->{'internal_mobile_app_rtb'}) {
        push(@an_internal_mobile,
            {type => 'item', name => gettext('Mobile RTB-blocks'), url => '/v2/internal/mobile/rtb/'});
    }

    if (@an_internal_mobile) {
        push(@an_internal, {type => 'sub-group', items => \@an_internal_mobile});
    }

    if (@an_internal) {
        push(
            @items,
            {
                type  => 'group',
                name  => gettext('Yandex services'),
                url   => $an_internal[0]->{'url'},
                items => \@an_internal
            }
        );
    }

    ####################################################################################################################
    # DSP
    ####################################################################################################################
    {
        my @dsp_list = ();
        if ($resources->{'dsp'}) {
            push(
                @dsp_list,
                {
                    type => 'item',
                    name => pgettext('DSP connections', 'Connections'),
                    url  => '/v2/dsp/connections/'
                }
            );

            if ($self->get_option('cur_cmdpath') eq 'dsp') {
                push(
                    @dsp_list,
                    {
                        type => 'item',
                        name => gettext('Deleted connections'),
                        url  => '/v2/dsp/connections/archive/'
                    }
                  )
                  if $deleted
                      || $resources->{'dsp_deleted'};
            }

            # DSP tools
            if ($resources->{'dsp'}) {
                my @dsp_tools = ();

                push(
                    @dsp_tools,
                    {
                        type => 'sub-item',
                        name => gettext('Sandbox'),
                        url  => $self->make_cmd(test => 'dsp')
                    }
                ) if $resources->{'dsp_testing'};

                push(
                    @dsp_tools,
                    {
                        type => 'sub-item',
                        name => gettext('Statistics responses'),
                        url  => $self->make_cmd(statistics_responses => 'dsp')
                    }
                ) if $resources->{'statistics_dsp_response'};

                push(
                    @dsp_list,
                    {
                        type  => 'item',
                        url   => '#',
                        name  => gettext('Tools'),
                        items => \@dsp_tools,
                    }
                ) if @dsp_tools;
            }
        }

        my @dsp = ();

        push(
            @dsp,
            {
                type  => 'group',
                name  => pgettext('DSP connections', 'Connections'),
                url   => $dsp_list[0]->{'url'},
                items => \@dsp_list,
            }
        ) if @dsp_list;

        push(
            @dsp,
            {
                type => 'item',
                name => gettext('Documentation'),
                url  => gettext('https://tech.yandex.ru/rtb/doc/api/index-docpage/')
            }
        ) if $resources->{'dsp_documentation'};

        push(
            @items,
            {
                type  => 'group',
                name  => gettext('Advertising platforms'),
                url   => $dsp[0]->{'url'},
                items => \@dsp,
            }
        ) if @dsp;
    }

    {
        push(
            @items,
            {
                type  => 'group',
                name  => gettext('SSP'),
                url   => '/v2/ssp/moderation/',
                items => [
                    {
                        type => 'item',
                        name => gettext('Moderation'),
                        url  => '/v2/ssp/moderation/',
                    },
                ],
            }
        ) if $resources->{'ssp_link_mobile_app'} || $resources->{'ssp_link_context_rtb'};
    }

    return @items
      ? {
        type  => 'group',
        name  => gettext('Products'),
        url   => ($items[0]->{'url'} // throw gettext('No link in first element')),
        items => \@items,
      }
      : ();
}

sub _menu__statistics {
    my ($self, $controller, $resources) = @_;

    return () if $self->get_option('cur_user', {blackbox => TRUE})->{'blackbox'};

    my @items;

    push(
        @items,
        {
            type => 'item',
            name => gettext('Reports'),
            url  => '/v2/statistics/reports/',
        }
    );

    push(
        @items,
        {
            name => gettext('Create report'),
            type => 'item',
            url  => '/v2/statistics/report/'
        }
    );

    ####################################################################################################################
    # Перезабор статистики
    ####################################################################################################################
    {
        push(
            @items,
            {
                type => 'item',
                name => gettext('Statistics update'),
                url  => $self->make_cmd(list => 'queue_update_statistics')
            }
        ) if $self->check_rights('queue_statistics_intake');
    }

    push(
        @items,
        {
            type => 'item',
            name => gettext('Video content reports'),
            url  => '/v2/video/stat-files/',
        }
    ) if @{$self->video_stat_files->get_all(limit => 1)};

    ###
    return @items && $resources->{'statistics'}
      ? {
        type  => 'group',
        name  => gettext('Statistics'),
        url   => '/v2/statistics/reports/',
        items => \@items
      }
      : ();
}

sub _page_is_default {
    my ($self) = @_;

    $self->_is_cmd_path(reverse($self->default_cmd()));
}

sub _tl2html {
    my ($log, $level) = @_;

    $level ||= 0;

    my $display = !$level ? 'block' : 'none';
    my $res = "<div style=\"padding-left: 20pt; display: $display;\">";

    foreach my $l (@$log) {
        my $text = html_encode($l->[0]);
        for ($text) {
            s/ /&nbsp;/g;
            s/\r|\n|\r\n/<br>/g;
        }
        my $time = sprintf('%f',   $l->[1]{'t'});
        my $prc  = sprintf('%.2f', $l->[1]{'prc'});

        $res .= '<table style="background-color: #eeeeee; width: 100%;"'
          . ' onmouseover="this.parentNode.style.backgroundColor=\'#cccccc\'" onmouseout="this.parentNode.style.backgroundColor=\'\'"><tr';
        $res .=
            ' style="cursor: pointer;"'
          . ' onclick="var tbl = this.parentNode; while (tbl.nodeName != \'TABLE\') { tbl = tbl.parentNode};'
          . 'var chld_div = tbl.nextSibling;'
          . 'if (this.firstChild.innerHTML == \'+\') {chld_div.style.display = \'block\'; this.firstChild.innerHTML = \'-\';} else {chld_div.style.display = \'none\'; this.firstChild.innerHTML = \'+\';};'
          . 'return false;"'
          if exists($l->[2]);
        $res .=
            '><th width="15pt" valign="top">'
          . (exists($l->[2]) ? '+' : '&nbsp;') . '</th>'
          . "<th valign=\"top\" width=\"100pt\">$time sec:</th><td valign=\"top\""
          . (
            $level
            ? "style=\"background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAUAAAAFCAIAAAACDbGyAAAAAXNSR0IArs4c6QAAABRJREFUCNdjfH1oPQMSYGJABaTyAbokAmZIPrAXAAAAAElFTkSuQmCC); background-size: $prc% 100%; background-repeat: no-repeat;\""
            : ''
          ) . ">$text</td></tr></table>";
        $res .= _tl2html($l->[2], $level + 1) if exists($l->[2]);
    }
    $res .= '</div>';

    return $res;
}

TRUE;
