package WebInterface::Controller;

use qbit;

use base qw(QBit::WebInterface::Controller::BEMHTML);

use WebInterface::Controller::_Utils::ViewOptions;

__PACKAGE__->register_rights(
    [
        {
            name        => 'access_rights',
            description => sub {gettext('Rights to access into interface')},
            rights      => {
                login       => d_gettext('Right to use interface'),
                yndx_login  => d_gettext('Right to use interface by internal users'),
                fake_login  => d_gettext('Right to use interface using another login'),
                view_search => d_gettext('Right to view search'),
            }
        }
    ]
);

$QBit::WebInterface::Request::MAX_POST_REQEST_SIZE   = 30 * 1024 * 1024;
%QBit::WebInterface::Controller::TEMPLATE_PRE_DEFINE = (
    hide_ref => sub {
        my ($url) = @_;
        return "/main/redir?url=$url";
    },
);

sub MODIFY_CODE_ATTRIBUTES {
    my ($package, $sub, @attrs) = @_;

    my @unknown_attrs = ();

    foreach my $attr (@attrs) {
        if ($attr =~ /^WOAUTH$/) {
            $package->_set_cmd_attr($sub, WOAUTH => TRUE);
        } else {
            push(@unknown_attrs, $attr);
        }
    }

    return $package->SUPER::MODIFY_CODE_ATTRIBUTES($sub, @unknown_attrs);
}

sub as_xml {
    my ($self, $data, %opts) = @_;
    $self->SUPER::as_xml(
        {
            partner => {
                version => "1.0",
                %$data,
            },
        },
        KeepRoot => 1,
        NoAttr   => 1,
        %opts,
    );
}

sub error {
    my ($self, $error) = @_;

    return $self->from_bem_template('common/error.bem.tt2', vars => {message => $error});
}

sub extract_params {
    my ($self, $ignored_params) = @_;

    my $fields = {};

    map {
        /^([^\.]+)\.([^\.]+)$/;
        if (defined($1)) {
            $fields->{$1}->{$2} = $self->request->param($_);
        } else {
            $fields->{$_} = $self->request->param($_);
        }
      } grep {
        !exists($ignored_params->{$_})
      } $self->request->param_names();

    return $fields;
}

sub from_bem_template {
    my ($self, @args) = @_;

    $self->app->_menu($self);
    $QBit::WebInterface::Controller::TEMPLATE_PRE_DEFINE{'get_template_content'} //=
      sub {$self->app->text_template->get_content($_[0]);};

    $self->SUPER::from_bem_template(@args);
}

sub get_vo {
    my ($self, %opts) = @_;

    return WebInterface::Controller::_Utils::ViewOptions->new(%opts, controller => $self);
}

TRUE;
