package WebInterface::Controller::Domain;

use qbit;

use base qw(WebInterface::Controller);

use Exception::Form;
use Exception::Multistate::BadAction;

__PACKAGE__->model_accessors(domain => 'Application::Model::Domain',);

sub add : FORMCMD {
    my ($self) = @_;

    throw "/domain/add is deprecated";
}

sub list : CMD : DEFAULT {
    my ($self) = @_;

    my $domains = $self->domain->get_all(
        fields => [qw(id domain confirmed multistate_name actions users)],
        filter => $self->request->param('search'),
        limit  => 20,
    );

    return $self->from_bem_template(
        'domain/list.bem.tt2',
        vars => {
            domains        => $domains,
            search_example => 'domain like "*.yandex.ru"',
            filter_fields  => $self->domain->get_db_filter_fields(),
        }
    );
}

sub mfas_info : CMD {
    my ($self) = @_;

    throw "/domain/mfas_info is deprecated";
}

sub moderate : FORMCMD {
    my ($self) = @_;

    my $domain_categories = $self->domain->get_categories();
    my $refuse_reasons    = $self->domain->get_refuse_reasons();

    return (
        fields => [
            {name => 'id', type => 'hidden', value => $self->request->param('id')},
            (
                map {{name => "accept_$_", type => 'checkbox', label => $domain_categories->{$_}}}
                sort keys(%$domain_categories)
            ),
            (
                map {
                    {
                        name  => "refuse_$_",
                        type  => 'checkbox',
                        label => $refuse_reasons->{$_}{'message'},
                        level => $refuse_reasons->{$_}{'level'}
                    }
                  } keys(%$refuse_reasons)
            ),
            {name  => 'comment',           type => 'textarea', label   => gettext('Comment')},
            {label => gettext('Moderate'), type => 'button',   subtype => 'submit'},
        ],

        vars => {domain => $self->domain->get_all(id => $self->request->param('id'))->[0],},

        pre_process => sub {
            my ($form) = @_;

            my $res;
            try {
                $res = $self->domain->do_action($form->get_value('id'), 'get_to_moderate');
            }
            catch Exception::Multistate::BadAction with {

            };

            return $form->break($self->denied())
              unless defined($res);
        },

        save => sub {
            my ($form) = @_;

            my @categories =
              map {$_->name =~ /^accept_(\d+)/; $1}
              grep {$_->name =~ /^accept_/ && $_->value} @{$form->get_fields()};
            throw Exception::Form gettext('Too many categories') if @categories > 1;

            my @refuse_reasons =
              map {$_->name =~ /^refuse_(\d+)/; $1}
              grep {$_->name =~ /^refuse_/ && $_->value} @{$form->get_fields()};

            throw Exception::Form gettext('Invalid arguments') if @categories && @refuse_reasons;

            if (@categories) {
                $self->domain->do_action($form->get_value('id'), 'moderate_accept', category => $categories[0]);
            } else {
                $self->domain->do_action($form->get_value('id'), 'moderate_refuse', reasons => \@refuse_reasons);
            }
        },

        template => 'domain/moderate.bem.tt2',

        redirect => 'need_moderate_list',
    );
}

sub need_moderate_list : CMD {
    my ($self) = @_;

    return $self->denied();    # unless $self->check_rights2('do_domain_action_get_to_moderate');

    my $domains = $self->domain->get_all(
        fields    => [qw(id domain reg_date)],
        actions   => 1,
        by_action => 'get_to_moderate',
    );

    return $self->from_bem_template('domain/need_moderate_list.bem.tt2', vars => {domains => $domains,});
}

1;
