package WebInterface::Controller::Inviter;

use qbit;

use base qw(WebInterface::Controller);

use Exception::Multistate;
use Exception::Multistate::BadAction;
use Exception::Multistate::NotFound;
use Exception::Validation::BadArguments;

eval {require Exception::Multistate::BadAction};

__PACKAGE__->model_accessors(
    inviter   => 'Application::Model::Inviter',
    users     => 'Application::Model::Users',
    rbac      => 'Application::Model::RBAC',
    api_adfox => 'Application::Model::API::Yandex::AdFox',
);

sub add : CMD {
    my ($self) = @_;
    return $self->redirect2url('/v2/inviter/add/');
}

sub accept : CMD {
    # no :SAFE - external link
    my ($self) = @_;

    my $invitation_link_is_active;
    my $invitation_link_can_be_bound;
    my $invitation_link_is_bound;
    my $user_already_has_role;
    my $was_error_in_getting_invite;
    my $invitation_is_expired;

    my $invitation_id = $self->request->param('id');

    try {
        my $tmp_rights = $self->app->add_tmp_rights(qw(inviter_view inviter_view_all));

        $invitation_is_expired = $self->inviter->is_expired($invitation_id);

        $invitation_link_can_be_bound = $self->inviter->check_action($invitation_id, 'bind');
        my $invitation_link_can_be_registered = $self->inviter->check_action($invitation_id, 'register');

        $invitation_link_is_bound = $invitation_link_can_be_registered;
        $invitation_link_is_active = $invitation_link_can_be_bound || $invitation_link_can_be_registered;

        $user_already_has_role = $self->inviter->has_user_role_already($self->request->param('id'));
    }
    catch Exception::Multistate catch Exception::Validation::BadArguments with {
        $was_error_in_getting_invite = TRUE;
    };

    return $self->error(gettext('Invitation is expired'))
      if $invitation_is_expired;
    return $self->error(gettext('You already have this role'))
      if $user_already_has_role;
    return $self->error(gettext('Incorrect invite link'))
      if $was_error_in_getting_invite || !$invitation_link_is_active;

    my $mod = $self->request->param('mod', '');

    my $cur_user = $self->get_option('cur_user');

    if (($mod eq 'continue' || $invitation_link_is_bound) && !$self->check_rights('yndx_login')) {

        my $error;

        if ($invitation_link_can_be_bound) {
            try {
                my $tmp_rights = $self->app->add_tmp_rights(qw(inviter_view inviter_view_all));
                $self->inviter->do_action($invitation_id, 'bind', partner_id => $cur_user->{'id'});
            }
            catch Exception::Multistate::BadAction catch Exception::Multistate::NotFound with {
                $error = gettext('Incorrect invite link');
            };
        }

        return $self->error($error) if defined($error);

        if ($self->users->check_action($cur_user->{'id'}, 'provide_contacts')) {
            return $self->redirect(
                'contacts',
                path => 'settings',
                retpath =>
                  $self->app->make_cmd('accept', 'inviter', id => $self->request->param('id'), mod => 'continue'),
            );
        }

        try {
            my $tmp_rights = $self->app->add_tmp_rights(qw(inviter_view inviter_view_all));
            $self->inviter->do_action($invitation_id, 'register');
        }
        catch Exception::Multistate::BadAction catch Exception::Multistate::NotFound with {
            $error = gettext('Incorrect invite link');
        };

        return $self->error($error) if defined($error);

        return $self->redirect('show', path => 'dashboard');
    } elsif ($mod eq 'relogin') {
        return $self->redirect(
            'logout',
            path    => 'main',
            retpath => $self->app->make_cmd('accept', 'inviter', id => $self->request->param('id'), mod => 'continue')
        );
    } else {
        return $self->from_bem_template(
            'inviter/choice_mod.bem.tt2',
            vars => {
                id_invite => $self->request->param('id'),
                login     => $cur_user->{'display_login'},
            }
        );
    }
}

sub list : CMD : DEFAULT {
    my ($self) = @_;
    return $self->redirect2url('/v2/inviter/list/');
}

TRUE;
