package WebInterface::Controller::Kladr;

use qbit;

use base qw(WebInterface::Controller);

__PACKAGE__->model_accessors(kladr => 'Application::Model::Kladr');

sub index : CMD {
    my ($self) = @_;

    my $code =
      $self->kladr->extract_street_code({map {$_ => $self->request->param($_)} qw(street town city district region)});

    my $index;
    if (
        my $address = $self->kladr->validate_address(
            $code, map {$self->request->param($_)} qw{home building construction flat postcode}
        )
       )
    {
        $index = $address->{'postcode'} unless $address->{'postcode'} =~ /^0*$/;
    }

    return $self->as_json($index);
}

sub street : CMD {
    my ($self) = @_;

    my $code = $self->kladr->extract_street_code({map {$_ => $self->request->param($_)} qw(town city district region)});

    return $self->as_jsonp(
        $self->request->param('callback'),
        [
            $self->request->param('part'),
            [map {[kladrstreet => @$_]} @{$self->kladr->get_streets_by_part($code, $self->request->param('part', ''))}],
            {r => 1, n => 0}
        ]
    );
}

sub towns : CMD {
    my ($self) = @_;

    return $self->as_json($self->kladr->get_towns_by_code($self->request->param('code')));
}

1;
