package WebInterface::Controller::MainPage;

use qbit;

use base qw(WebInterface::Controller);

use Exception::Denied;

__PACKAGE__->model_accessors(
    users => 'Application::Model::Users',
    rbac  => 'Application::Model::RBAC',
    news  => 'Application::Model::News',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'web_interface_main',
            description => d_gettext('Rights to use elements at main web interface pages and shared page parts'),
            rights      => {
                view_partner_help  => d_gettext('Right to view partner help'),
                view_partner2_help => d_gettext('Right to view partner2 help'),
            },
        }
    ]
);

sub fake_login : CMD {
    my ($self) = @_;

    return $self->denied() unless $self->get_option('fake_login');

    return $self->error(gettext('Login is not specified')) unless defined($self->request->param('login'));

    if ($self->users->get_by_login($self->request->param('login'), fields => ['id'])) {
        $self->response->add_cookie(fakelogin => $self->request->param('login'));
        return $self->redirect2url('/');
    } else {
        return $self->error(gettext('Login "%s" does not exists', $self->request->param('login')));
    }
}

sub fake_logout : CMD {
    my ($self) = @_;

    $self->response->delete_cookie('fakelogin');
    $self->redirect2url('/');
}

sub login : CMD : WOAUTH {
    my ($self) = @_;

    my $passport_host = $self->app->get_passport_host();

    my $retpath = $self->request->param('retpath', '');
    my $url =
      "https://$passport_host/passport?mode=auth&from=pi&retpath=" . uri_escape($self->_get_url_absolute($retpath));

    return $self->redirect2url($url);
}

sub logout : CMD : WOAUTH {
    my ($self) = @_;

    if ($self->request->cookie('fakelogin')) {
        $self->response->delete_cookie('fakelogin');
    }

    my $passport_host = $self->app->get_passport_host();

    my $retpath = $self->request->param('retpath', '');
    my $url =
        "https://$passport_host/passport?mode=logout&from=pi&yu="
      . uri_escape($self->request->cookie('yandexuid'))
      . "&retpath="
      . uri_escape($self->_get_url_absolute($retpath));

    return $self->redirect2url($url);
}

sub page : CMD : WOAUTH {
    my ($self) = @_;

    my $roles = $self->rbac->get_cur_user_roles;

    if (keys(%$roles)) {
        return $self->redirect2url('/v2/dashboard/');
    }

    return $self->redirect2url('/');
}

sub passport_registration : CMD : WOAUTH {
    my ($self) = @_;

    return $self->redirect2url(
        'https://passport.yandex.ru/registration?mode=register&from=&retpath=http://partner2.yandex.ru');
}

sub pdd : CMD : WOAUTH {
    my ($self) = @_;

    return $self->from_bem_template('main/pdd.bem.tt2');
}

sub redir : CMD {
    my ($self) = @_;

    my $url = $self->request->param('url');

    return $self->denied() unless $url;

    return $self->from_template(
        'main/redir.tt2',
        vars => {url => (($url =~ /^http:\/\//) ? $url : 'http://' . $url),},
        no_hf => TRUE,
    );
}

sub yan : CMD {
    my ($self) = @_;

    throw Exception::Denied gettext("You don't have access to this page")
      if $self->check_rights('yndx_login');

    my $yan_role_id = 9;

    my $user_has_yan_partner_role = exists($self->rbac->get_cur_user_roles()->{$yan_role_id});

    if (!$user_has_yan_partner_role) {

        my $user_id = $self->get_option('cur_user')->{'id'};

        {
            my $tmp_rights = $self->app->add_tmp_rights('rbac_user_role_set');
            $self->rbac->set_user_role($user_id, $yan_role_id);
        }

        {
            my $tmp_rights = $self->app->add_tmp_rights('do_user_action_request_yan_contract');
            $self->users->do_action($user_id, 'request_yan_contract');
        }

    }

    return $self->redirect('', path => 'dashboard');
}

TRUE;
