package WebInterface::Controller::Product::AN::ContextOnSite::Stripe;

use qbit;

use base qw(WebInterface::Controller);

__PACKAGE__->model_accessors(context_on_site_stripe => 'Application::Model::Product::AN::ContextOnSite::Stripe',);

sub add : FORMCMD {
    my ($self) = @_;

    my $disposition_ids = $self->context_on_site_stripe->get_disposition_ids();
    my $interaction_ids = $self->context_on_site_stripe->get_interaction_with_content_ids();
    my $type_ids        = $self->context_on_site_stripe->get_type_ids();
    my $animation_ids   = $self->context_on_site_stripe->get_animation_ids();

    return (
        title        => gettext('Adding new Stripe block to context campaign'),
        check_rights => ['context_on_site_stripe_add'],

        fields => [
            {
                name  => 'campaign_id',
                type  => 'select',
                label => gettext('Campaign'),
                items => [
                    {},
                    map {{value => $_->{'id'}, label => "$_->{'domain'} ($_->{'id'})", disabled => $_->{'disabled'}}}
                      sort {$a->{'domain'} cmp $b->{'domain'} || $a->{'id'} <=> $b->{'id'}}
                      @{$self->context_on_site_stripe->get_all_campaigns_for_adding()}
                ],
                required => TRUE,
            },
            {
                name  => 'appearance',
                type  => 'stripe_appearance',
                value => {
                    editable_fields => {
                        disposition_id => $disposition_ids,
                        interaction_id => $interaction_ids,
                        type_id        => $type_ids,
                        animation      => $animation_ids,
                    },
                },
            },
            {type => 'button', subtype => 'submit', label => gettext('Add')}
        ],

        save => sub {
            my ($form) = @_;

            my $stripe = $self->context_on_site_stripe->add((map {$_ => $form->get_value($_)} qw(campaign_id)),
                hash_transform($form->get_value('appearance'), [qw(disposition_id interaction_id type_id animation)]));

            $form->{'redirect_opts'}{'search_json'} =
              to_json({campaign_id => $stripe->{'campaign_id'}, id => $stripe->{'id'}});
        },

        redirect => 'list'
    );
}

sub action : CMD : SAFE {
    my ($self) = @_;

    my %ignored_params = map {$_ => 1} qw(campaign_id id type ajax sign);

    $self->context_on_site_stripe->do_action(
        {
            campaign_id => $self->request->param('campaign_id'),
            id          => $self->request->param('id'),
        },
        $self->request->param('type'),
        map {$_ => $self->request->param($_)} grep {!exists($ignored_params{$_})} $self->request->param_names()
    );

    if ($self->request->param('ajax')) {
        my $block = $self->context_on_site_stripe->get(
            {
                campaign_id => $self->request->param('campaign_id'),
                id          => $self->request->param('id'),
            },
            fields => [grep {in_array($_, [qw(title type_id animation comment)])} $self->request->param_names()]
        );

        return $self->as_json($block);
    } else {
        return $self->redirect2url_internal($self->request->param('retpath'));
    }
}

sub appearance : FORMCMD {
    my ($self) = @_;

    throw "context_on_site_stripe/appearance is deprecated";
}

sub list : CMD : DEFAULT {
    my ($self) = @_;

    return $self->redirect2url('/v2/context/stripe/');
}

TRUE;
