package WebInterface::Controller::Product::InternalAN::InternalContextOnSite::Direct;

use qbit;

use base qw(WebInterface::Controller);

__PACKAGE__->model_accessors(
    internal_context_on_site_direct   => 'Application::Model::Product::InternalAN::InternalContextOnSite::Direct',
    internal_context_on_site_campaign => 'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign',
);

sub add : WIZARDCMD {
    my ($self) = @_;

    throw "internal_context_on_site_direct/add is deprecated";
}

sub action : CMD : SAFE {
    my ($self) = @_;

    my %ignored_params = map {$_ => 1} qw(id atype ajax sign);

    $self->internal_context_on_site_direct->do_action(
        $self->request->param('id'),
        $self->request->param('atype'),
        map {$_ => $self->request->param($_)} grep {!exists($ignored_params{$_})} $self->request->param_names()
    );

    if ($self->request->param('ajax')) {
        my $block = $self->internal_context_on_site_direct->get($self->request->param('id'),
            fields => [qw(caption type limit), $self->internal_context_on_site_direct->direct_appearance_fields()]);

        return $self->as_json($block);
    } else {
        return $self->redirect2url_internal($self->request->param('retpath'));
    }
}

sub direct_appearance : FORMCMD {
    my ($self) = @_;

    my $block = $self->internal_context_on_site_direct->get(
        $self->request->param('id'),
        fields => [
            'campaign_id',
            $self->internal_context_on_site_direct->direct_block_fields,
            $self->internal_context_on_site_direct->direct_appearance_fields()
        ]
    ) // return $self->response->status(404);

    my $campaign = $self->internal_context_on_site_campaign->get($block->{'campaign_id'}, fields => ['view_images']);

    return (
        title => gettext('Changing Direct block appearance'),

        fields => [
            {
                name  => 'id',
                type  => 'hidden',
                value => $self->request->param('id'),
            },
            {
                name        => 'appearance',
                type        => 'internal_context_direct_appearance',
                value       => $block,
                view_images => $campaign->{'view_images'},
            },
            {type => 'button', subtype => 'submit', label => gettext('Change')}
        ],

        save => sub {
            my ($form) = @_;

            $self->internal_context_on_site_direct->do_action($self->request->param('id'),
                'edit', %{$form->get_value('appearance')});
        },
    );
}

sub direct_block_select : FORMCMD {
    my ($self) = @_;

    my $block = $self->internal_context_on_site_direct->get($self->request->param('id'),
        fields => [$self->internal_context_on_site_direct->direct_block_fields()])
      // return $self->response->status(404);

    return (
        title => gettext('Changing Direct block appearance'),

        fields => [
            {
                name  => 'id',
                type  => 'hidden',
                value => $self->request->param('id'),
            },
            {
                name        => 'block_type',
                type        => 'direct_block_select',
                value       => $block,
                types_block => [
                    map {
                        delete($_->{'constructor_caption'});
                        $_->{'caption'} = $_->{'caption'}();
                        $_
                      } @{$self->internal_context_on_site_direct->get_types_direct_blocks}
                ],
            },
            {type => 'button', subtype => 'submit', label => gettext('Change')}
        ],

        save => sub {
            my ($form) = @_;

            $self->internal_context_on_site_direct->do_action($self->request->param('id'),
                'edit', %{$form->get_value('block_type')});

            my $block = $self->internal_context_on_site_direct->get(
                $self->request->param('id'),
                fields => [
                    qw(caption type limit block_caption),
                    $self->internal_context_on_site_direct->direct_appearance_fields()
                ]
            );

            $form->{'ajax_action_data'} = $block;
        },
    );
}

sub list : CMD : DEFAULT {
    my ($self) = @_;

    return $self->redirect2url('/v2/context/direct/');
}

TRUE;
