package WebInterface::Controller::Product::InternalAN::InternalContextOnSite::Stripe;

use qbit;

use base qw(WebInterface::Controller);

use Exception::Form;
use Utils::PublicID;

__PACKAGE__->model_accessors(
    internal_context_on_site_stripe => 'Application::Model::Product::InternalAN::InternalContextOnSite::Stripe',);

sub add : FORMCMD {
    my ($self) = @_;

    my $disposition_ids = $self->internal_context_on_site_stripe->get_disposition_ids();
    my $interaction_ids = $self->internal_context_on_site_stripe->get_interaction_with_content_ids();
    my $type_ids        = $self->internal_context_on_site_stripe->get_type_ids();
    my $animation_ids   = $self->internal_context_on_site_stripe->get_animation_ids();

    return (
        title        => gettext('Adding new Stripe block to internal context campaign'),
        check_rights => ['do_internal_context_on_site_stripe_add'],

        fields => [
            {
                name  => 'campaign_id',
                type  => 'select',
                label => gettext('Campaign'),
                items => [
                    {},
                    map {{value => $_->{'id'}, label => "$_->{'domain'} ($_->{'id'})", disabled => $_->{'disabled'}}}
                      sort {$a->{'domain'} cmp $b->{'domain'} || $a->{'id'} <=> $b->{'id'}}
                      @{$self->internal_context_on_site_stripe->get_all_campaigns_for_adding()}
                ],
                required => TRUE,
            },
            {
                name  => 'appearance',
                type  => 'stripe_appearance',
                value => {
                    editable_fields => {
                        disposition_id => $disposition_ids,
                        interaction_id => $interaction_ids,
                        type_id        => $type_ids,
                        animation      => $animation_ids,
                    },
                },
            },
            {type => 'button', subtype => 'submit', label => gettext('Add')}
        ],

        save => sub {
            my ($form) = @_;

            my $public_id =
              $self->internal_context_on_site_stripe->add((map {$_ => $form->get_value($_)} qw(campaign_id)),
                hash_transform($form->get_value('appearance'), [qw(disposition_id interaction_id type_id animation)]));

            my $stripe = {};
            @$stripe{qw(campaign_id id)} = (split_block_public_id($public_id))[1, 2];

            $form->{'redirect_opts'}{'search_json'} =
              to_json({campaign_id => $stripe->{'campaign_id'}, id => $stripe->{'id'}});
        },

        redirect => 'list'
    );
}

sub action : CMD : SAFE {
    my ($self) = @_;

    my %ignored_params = map {$_ => 1} qw(id atype ajax sign);

    $self->internal_context_on_site_stripe->do_action(
        {
            campaign_id => $self->request->param('campaign_id'),
            id          => $self->request->param('id'),
        },
        $self->request->param('type'),
        map {$_ => $self->request->param($_)} grep {!exists($ignored_params{$_})} $self->request->param_names()
    );

    if ($self->request->param('ajax')) {
        my $block = $self->internal_context_on_site_stripe->get(
            {
                campaign_id => $self->request->param('campaign_id'),
                id          => $self->request->param('id'),
            },
            fields => [grep {in_array($_, [qw(title type_id animation comment)])} $self->request->param_names()]
        );

        return $self->as_json($block);
    } else {
        return $self->redirect2url_internal($self->request->param('retpath'));
    }
}

sub appearance : FORMCMD {
    my ($self) = @_;

    my @errors    = ();
    my @id_fields = qw(campaign_id id);
    foreach my $field_name (@id_fields) {
        push(@errors, gettext("Missed required field '%s'", $field_name))
          unless $self->request->param($field_name);
    }
    my $block = $self->internal_context_on_site_stripe->get(
        {map {$_ => $self->request->param($_)} @id_fields},
        fields => [
            qw(type_id type_name animation animation_name disposition_id interaction_id interaction_name disposition_name editable_fields available_fields)
        ]
      ) // return $self->response->status(404)
      unless @errors;

    return (
        pre_process => sub {
            return $_[0]->break($self->error(join('<br>', @errors))) if @errors;
        },

        title => gettext('Changing stripe appearance'),

        fields => [
            {
                name  => 'campaign_id',
                type  => 'hidden',
                value => $self->request->param('campaign_id'),
            },
            {
                name  => 'id',
                type  => 'hidden',
                value => $self->request->param('id'),
            },
            {
                name  => 'appearance',
                type  => 'stripe_appearance',
                value => $block,
            },
            {type => 'button', subtype => 'submit', label => gettext('Change')}
        ],

        save => sub {
            my ($form) = @_;

            foreach my $field_name (@id_fields) {
                throw Exception::Form gettext("Missed required field '%s'", $field_name)
                  unless $self->request->param($field_name);
            }

            $self->internal_context_on_site_stripe->do_action({map {$_ => $self->request->param($_)} @id_fields},
                'edit',
                hash_transform($form->get_value('appearance'), [qw(disposition_id interaction_id type_id animation)]));
        },
    );
}

sub list : CMD : DEFAULT {
    my ($self) = @_;

    my $vo = $self->get_vo(
        model       => $self->internal_context_on_site_stripe,
        sort        => 'create_date',
        sortdesc    => TRUE,
        trash       => TRUE,
        show_search => $self->check_rights('internal_context_on_site_campaign_view_all'),
    );

    my $internal_context_on_site_stripes;
    my $block_count;
    my $count;

    if ($vo->show_search_data()) {
        $internal_context_on_site_stripes = $self->internal_context_on_site_stripe->get_all(
            fields => [
                qw(
                  campaign_id
                  id
                  public_id
                  title
                  comment
                  managers
                  multistate_name
                  domain
                  actions
                  editable_fields
                  available_fields
                  type_id
                  type_name
                  animation
                  animation_name
                  create_date
                  is_campaign_deleted
                  statistics_exists
                  )
            ],
            $vo->get_model_opts()
        );

        $block_count = $self->internal_context_on_site_stripe->found_rows();

        $count = $self->internal_context_on_site_stripe->get_fields_cnt(
            fields => [['id', 'campaign_id'], 'campaign_id'],
            filter => {$vo->get_model_opts()}->{'filter'},
        );
    }

    return $self->from_bem_template(
        'product/internal_an/internal_context_on_site/stripe/list.bem.tt2',
        vars => {
            stripes           => $internal_context_on_site_stripes,
            stripes_count     => $block_count,
            count_id          => $count->{'cnt_id'},
            count_campaign_id => $count->{'cnt_campaign_id'},
            $vo->get_template_vars()
        }
    );
}

TRUE;
