package WebInterface::Controller::Product::InternalAN::InternalSearchOnSite::Direct;

use qbit;

use base qw(WebInterface::Controller);

use Exception::Form;
use Exception::Validation::BadArguments;

__PACKAGE__->model_accessors(
    internal_search_on_site_direct => 'Application::Model::Product::InternalAN::InternalSearchOnSite::Direct',);

sub add : WIZARDCMD {
    my ($self) = @_;

    return (
        caption => gettext('Adding new Direct block to internal search campaign'),

        check_rights => ['do_internal_search_on_site_direct_add'],

        steps => [
            {
                title  => gettext('Select the number of ads'),
                fields => [
                    {
                        name     => 'caption',
                        type     => 'input',
                        label    => gettext('Block caption'),
                        value    => gettext('Block Direct'),
                        length   => 255,
                        required => TRUE,
                    },
                    {
                        name  => 'campaign_id',
                        type  => 'select',
                        label => gettext('Campaign'),
                        items => [
                            {},
                            map {{value => $_->{'page_id'}, label => "$_->{'domain'} ($_->{'page_id'})"}}
                              sort {$a->{'domain'} cmp $b->{'domain'} || $a->{'page_id'} <=> $b->{'page_id'}}
                              @{$self->internal_search_on_site_direct->get_all_campaigns_for_adding()}
                        ],
                        required => TRUE,
                    },
                    {
                        name        => 'direct_block_select',
                        type        => 'direct_block_select',
                        types_block => $self->internal_search_on_site_direct->get_types_direct_blocks,
                    },
                    {type => 'button', subtype => 'submit', label => gettext('Next')}
                ],
            },

            {
                title  => gettext('Banners settings'),
                fields => sub {
                    my ($wizard) = @_;

                    my $block = $wizard->get_value('direct_block_select');

                    return (
                        {
                            name  => 'appearance',
                            type  => 'internal_search_direct_appearance',
                            value => {
                                type  => $block->{'type'},
                                limit => $block->{'limit'}
                            }
                        },
                        {type => 'button', subtype => 'submit', label => gettext('Add')}
                    );
                },
            }
        ],

        save => sub {
            my ($wizard) = @_;

            my $block      = $wizard->get_value('direct_block_select');
            my $appearance = $wizard->get_value('appearance');

            my $id = $self->internal_search_on_site_direct->add(
                (map {$_ => $wizard->get_value($_)} qw(campaign_id caption)),
                (map {$_ => $block->{$_}} $self->internal_search_on_site_direct->direct_block_fields()),
                map {$_ => $appearance->{$_}} $self->internal_search_on_site_direct->direct_appearance_fields()
            );

            $wizard->{'redirect_opts'}{'search_json'} = to_json({campaign_id => $id->[0], id => $id->[1]});
        },

        redirect => 'list'
    );
}

sub action : CMD : SAFE {
    my ($self) = @_;

    my %ignored_params = map {$_ => 1} qw(id atype ajax sign);

    my $error;
    try {
        $self->internal_search_on_site_direct->do_action(
            $self->request->param('id'),
            $self->request->param('atype'),
            map {$_ => $self->request->param($_)} grep {!exists($ignored_params{$_})} $self->request->param_names()
        );
    }
    catch Exception::Validation::BadArguments with {
        $error = shift->message;
    };

    if ($self->request->param('ajax')) {
        return $self->as_json({error => $error}) if $error;

        my $block = $self->internal_search_on_site_direct->get($self->request->param('id'),
            fields => [qw(caption type limit), $self->internal_search_on_site_direct->direct_appearance_fields()]);

        return $self->as_json($block);
    } else {
        return $error ? $self->error($error) : $self->redirect2url_internal($self->request->param('retpath'));
    }
}

sub direct_appearance : FORMCMD {
    my ($self) = @_;

    my $block = $self->internal_search_on_site_direct->get(
        $self->request->param('id'),
        fields => [
            $self->internal_search_on_site_direct->direct_block_fields,
            $self->internal_search_on_site_direct->direct_appearance_fields(),
        ]
    ) // return $self->response->status(404);

    return (
        title => gettext('Changing Direct block appearance'),

        fields => [
            {
                name  => 'id',
                type  => 'hidden',
                value => $self->request->param('id'),
            },
            {
                name  => 'appearance',
                type  => 'internal_search_direct_appearance',
                value => $block,
            },
            {type => 'button', subtype => 'submit', label => gettext('Change')}
        ],

        save => sub {
            my ($form) = @_;

            try {
                $self->internal_search_on_site_direct->do_action($self->request->param('id'),
                    'edit', %{$form->get_value('appearance')});
            }
            catch Exception::Validation::BadArguments with {
                throw Exception::Form $_[0];
            };
        },
    );
}

sub direct_block_select : FORMCMD {
    my ($self) = @_;

    my $block = $self->internal_search_on_site_direct->get($self->request->param('id'),
        fields => [$self->internal_search_on_site_direct->direct_block_fields()])
      // return $self->response->status(404);

    return (
        title => gettext('Changing Direct block appearance'),

        fields => [
            {
                name  => 'id',
                type  => 'hidden',
                value => $self->request->param('id'),
            },
            {
                name        => 'block_type',
                type        => 'direct_block_select',
                value       => $block,
                types_block => $self->internal_search_on_site_direct->get_types_direct_blocks,
            },
            {type => 'button', subtype => 'submit', label => gettext('Change')}
        ],

        save => sub {
            my ($form) = @_;

            try {
                $self->internal_search_on_site_direct->do_action($self->request->param('id'),
                    'edit', %{$form->get_value('block_type')});
            }
            catch Exception::Validation::BadArguments with {
                throw Exception::Form $_[0];
            };

            my $block = $self->internal_search_on_site_direct->get(
                $self->request->param('id'),
                fields => [
                    qw(caption type limit block_caption),
                    $self->internal_search_on_site_direct->direct_appearance_fields()
                ]
            );

            $form->{'ajax_action_data'} = $block;
        },
    );
}

sub list : CMD : DEFAULT {
    my ($self) = @_;

    my $vo = $self->get_vo(
        model       => $self->internal_search_on_site_direct,
        sort        => 'id',
        trash       => TRUE,
        show_search => $self->check_rights('internal_search_on_site_campaign_view_all'),
    );

    my $list;
    my $block_count;
    my $count;

    if ($vo->show_search_data()) {
        $list = $self->internal_search_on_site_direct->get_all(
            fields => [
                qw(
                  id
                  campaign_id
                  public_id
                  caption
                  domain
                  type
                  limit
                  block_caption
                  available_fields
                  editable_fields
                  actions
                  multistate_name
                  comment
                  is_campaign_deleted
                  statistics_exists
                  ),
                $self->internal_search_on_site_direct->direct_appearance_fields()
            ],
            $vo->get_model_opts()
        );

        $block_count = $self->internal_search_on_site_direct->found_rows();

        $count = $self->internal_search_on_site_direct->get_fields_cnt(
            fields => [['id', 'campaign_id'], 'campaign_id'],
            filter => {$vo->get_model_opts()}->{'filter'},
        );
    }

    return $self->from_bem_template(
        'product/internal_an/internal_search_on_site/direct/list.bem.tt2',
        vars => {
            blocks            => $list,
            block_count       => $block_count,
            search_example    => 'domain like "*.yandex.ru"',
            count_id          => $count->{'cnt_id'},
            count_campaign_id => $count->{'cnt_campaign_id'},
            $vo->get_template_vars(),
        },
    );
}

TRUE;
