package WebInterface::Controller::Product::VideoAN::Site;

use qbit;

use base qw(WebInterface::Controller);

use File::Slurp qw(read_file);
use File::Temp qw(tempfile);

__PACKAGE__->model_accessors(
    video_stat_files     => 'Application::Model::Product::VideoAN::Site::Video::StatFiles',
    api_media_storage_s3 => 'Application::Model::API::Yandex::MediaStorage::S3',
);

__PACKAGE__->register_rights(
    [
        {
            name        => 'video_an_site',
            description => d_gettext('Rights to use dsp'),
            rights      => {video_an_site_view_stat_files => d_gettext('Right to view video stat files'),}
        }
    ]
);

sub add : FORMCMD {
    my ($self) = @_;

    return $self->redirect2url('/v2/video/sites');
}

sub action : CMD : SAFE {
    my ($self) = @_;

    throw "/video_an_site/action is deprecated";

}

sub get_video_stat_file : CMD {
    my ($self) = @_;

    return $self->denied() unless $self->check_rights('video_an_site_view_stat_files');

    my $file_id = $self->request->param('id');

    return $self->not_found() unless $file_id;

    my $file = $self->video_stat_files->get($file_id, fields => [qw(name uncompress_data s3_key)]);

    return $self->not_found() unless $file;

    my $data;
    my $name;
    if (defined $file->{'s3_key'}) {
        my $file_name = (tempfile(UNLINK => 1))[1];
        $self->api_media_storage_s3->get_file($file->{s3_key}, $file_name);
        $data = read_file($file_name);
        $name = $file->{'name'} . '.zip';
    } else {
        $data = $file->{'uncompress_data'};
        $name = $file->{'name'} . '.xls';
    }

    return $self->send_file(
        data     => $data,
        filename => $name,
    );
}

sub list : CMD : DEFAULT {
    my ($self) = @_;

    return $self->redirect2url('/v2/video/sites');
}

TRUE;
