package WebInterface::Controller::Queue::UpdateStatistics;

use qbit;

use base qw(WebInterface::Controller::Queue);

sub list : CMD : DEFAULT {
    my ($self) = @_;

    return $self->denied() unless $self->check_rights('queue_statistics_intake');

    my $vo = $self->get_vo(
        model          => $self->queue,
        sort           => 'add_dt',
        sortdesc       => TRUE,
        show_search    => TRUE,
        default_filter => {method_type => 1},
    );

    my $update_tasks = $self->queue->get_all(
        fields => [
            qw(id add_dt multistate_name remaining_time completed_percent params_ref can_be_run login error_description)
        ],
        $vo->get_model_opts(),
    );

    foreach my $task (@$update_tasks) {

        $task->{'product_names'} = [];
        foreach my $product_name (@{$task->{'params_ref'}{'products'}}) {

            try {
                my $title = $self->statistics->get_level_full_title($product_name);
                push @{$task->{'product_names'}}, $title;
            }
            catch {
                # Уровни статистики поменялись после решения задачи
                # PI-694 - Статистика дистрибуции в одну строку.
                # В codebase уже нет данных о старых уровнях, поэтому
                # показываем не title (потому что его нет), а текстовое имя
                # продукта
                push @{$task->{'product_names'}}, $product_name;
            }

        }

        if (defined($task->{'params_ref'}->{'logins'}) && ref($task->{'params_ref'}->{'logins'}) eq 'ARRAY') {
            $task->{'params_ref'}->{'logins'} = join(', ', @{$task->{'params_ref'}->{'logins'}});
        } elsif (!defined($task->{'params_ref'}->{'logins'})) {
            # there can be no logins in update statistics task
        } else {
            throw gettext("Field 'login' is not in the expected format.");
        }
    }

    return $self->from_bem_template(
        'queue/update_statistics.bem.tt2',
        vars => {
            update_tasks   => $update_tasks,
            total_count    => $self->queue->found_rows(),
            search_example => 'multistate = finished_with_success',
            $vo->get_template_vars(),
        }
    );
}

TRUE;
