package WebInterface::Controller::RBAC;

use qbit;

use base qw(QBit::WebInterface::Controller::RBAC);

sub role_add : FORMCMD {
    my $self = shift;

    return $self->SUPER::role_add(@_);
}

sub role_rights : FORMCMD {
    my $self = shift;

    if ($self->app->get_option('allow_to_change_rbac_role_rights')) {
        return $self->SUPER::role_rights(@_);
    } else {
        my %role_rights = $self->SUPER::role_rights(@_);

        pop(@{$role_rights{'fields'}});
        delete($role_rights{'save'});

        return %role_rights;
    }
}

sub roles : CMD : DEFAULT {
    my $self = shift;

    return $self->SUPER::roles(@_);
}

TRUE;
