package WebInterface::Controller::TNSDict;

use qbit;

use base qw(WebInterface::Controller);

__PACKAGE__->model_accessors(
    internal_context_on_site_campaign => 'Application::Model::Product::InternalAN::InternalContextOnSite::Campaign',
    tns_dict_article                  => 'Application::Model::TNSDict::Article',
    tns_dict_brand                    => 'Application::Model::TNSDict::Brand',
);

sub get_article_tree : CMD {
    my ($self) = @_;

    throw "/tns_dict/get_article_tree is deprecated";
}

sub get_brand_suggest : CMD {
    my ($self) = @_;

    return $self->denied() unless $self->check_rights('get_tns_dicts');

    my $data = $self->tns_dict_brand->get_brand_suggest(map {$self->request->param($_)} qw(id substring));

    return $self->as_json($data);
}

sub get_brands : CMD {
    my ($self) = @_;

    throw "/tns_dict/get_brands is deprecated";
}

TRUE;
