package WebInterface::Controller::_Utils::ViewOptions;

use qbit;

use base qw(QBit::Class);

use Exception::DBManager::Grammar;
use Exception::Validation::BadArguments::InvalidJSON;

__PACKAGE__->mk_ro_accessors(qw(controller model per_page page sort sortdesc search show_search show_search_data));

eval {require Exception::DBManager::Grammar};

sub get_model_opts {
    my ($self) = @_;

    $self->_fill_search();

    my $filter;

    my @permanent_filter = ();
    push(@permanent_filter, $self->{'permanent_filter'}) if defined($self->{'permanent_filter'});
    push(@permanent_filter, {multistate => $self->controller->request->param('deleted') ? 'deleted' : 'not deleted'})
      if $self->{'trash'};

    my %result;
    $result{'filter'} = [AND => [@permanent_filter]]
      if @permanent_filter;

    if ($self->show_search && $self->controller->check_rights('view_search')) {
        if ($self->{'search'}{'error'}) {
            $result{'filter'} = ['AND' => [\undef]];
        } else {
            my $filter = $self->search->{'data'};
            $filter //= $self->{'default_filter'};

            $result{'filter'} = [AND => [$filter, $result{'filter'}]]
              if defined($filter) && exists($result{'filter'});
            $result{'filter'} //= $filter;
        }
    }

    push_hs(
        %result,
        calc_rows => 1,
        offset    => ($self->page - 1) * $self->per_page,
        limit     => $self->per_page
    ) if $self->per_page;

    push_hs(%result, order_by => [[$self->sort, $self->sortdesc]]) if $self->sort;

    return %result;
}

sub get_template_vars {
    my ($self) = @_;

    $self->_fill_search();

    my $db_filter_fields        = $self->model->get_db_filter_fields();
    my $db_filter_simple_fields = $self->model->get_db_filter_simple_fields();

    if (exists $db_filter_fields->{multistate}) {
        my $en = $self->model->get_empty_name // 'EMPTY';
        $db_filter_fields->{multistate}{values}{'__EMPTY__'} = $en;
    }

    if ($self->{'trash'}) {
        if ($self->controller->request->param('deleted')) {
            if (ref(${$db_filter_simple_fields}[0]) eq 'ARRAY') {
                $_ = [grep {$_->{'name'} ne 'multistate'} @$_] foreach @$db_filter_simple_fields;
            } else {
                $db_filter_simple_fields = [grep {$_->{'name'} ne 'multistate'} @$db_filter_simple_fields];
            }
        } else {
            delete($db_filter_fields->{'multistate'}->{'values'}->{'deleted'})
              if exists($db_filter_fields->{'multistate'}) && exists($db_filter_fields->{'multistate'}->{'values'});
        }
    }

    return (
        (
            $self->controller->check_rights('view_search')
            ? (
                filter_fields        => $db_filter_fields,
                filter_simple_fields => $db_filter_simple_fields,
              )
            : ()
        ),
        deleted => $self->{'trash'} && $self->controller->request->param('deleted'),
        sort_field       => $self->sort,
        sort_desc        => $self->sortdesc,
        pager_perpage    => $self->per_page,
        show_search      => $self->show_search,
        show_search_data => $self->show_search_data,
        search           => $self->search->{'text'},
        search_json      => to_json($self->search->{'data'}),
        search_error     => $self->search->{'error'},
        vo_uri           => sub {$self->get_vo_uri(%{$_[0] // {}})},
        url_params       => $self->_get_vo_uri_params(),
        fields           => $self->model->{'__LAST_FIELDS__'},
    );
}

sub get_vo_uri {
    my ($self, %opts) = @_;

    my %fields;
    %fields = %{$self->_get_vo_uri_params(%opts, as_hash => 1)} unless $opts{no_params};

    my $origin = $opts{'with_origin'} ? $self->controller->app->request->url(no_uri => 1) : '';
    return $origin . $self->controller->app->make_cmd(undef, undef, %fields);
}

sub init {
    my ($self) = @_;

    my $per_page_default = 20;

    my $per_page_from_url    = $self->controller->request->param('per_page');
    my $per_page_from_cookie = $self->controller->request->cookie('per_page');

    if ($self->_per_page_is_correct($per_page_from_url)) {
        $self->{'per_page'} = $per_page_from_url;
        $self->controller->response->add_cookie(per_page => $per_page_from_url);
    } elsif ($self->_per_page_is_correct($per_page_from_cookie)) {
        $self->{'per_page'} = $per_page_from_cookie;
    } else {
        $self->{'per_page'} = $per_page_default;
    }

    if ($self->{'per_page'}) {
        $self->{'page'} = $self->controller->request->param('page', 1);
        $self->{'page'} = 1 unless $self->_is_positive_integer($self->{'page'});
    }

    $self->{'show_search_data'} ||=
         defined($self->controller->request->param('search'))
      || defined($self->controller->request->param('search_json'))
      || defined($self->controller->request->param('page'))
      || defined($self->controller->request->param('sort'))
      || !$self->show_search;

    $self->{'sort'}     = $self->controller->request->param('sort',     $self->{'sort'});
    $self->{'sortdesc'} = $self->controller->request->param('sortdesc', $self->{'sortdesc'});
}

sub _fill_search {
    my ($self) = @_;

    return if $self->search;

    if ($self->controller->request->param('search_json')) {
        try {
            $self->{'search'}{'data'} = from_json($self->controller->request->param('search_json'));
            $self->{'search'}{'text'} = $self->model->get_db_filter($self->{'search'}{'data'}, type => 'text');
        }
        catch Exception::Validation::BadArguments::InvalidJSON with {
            throw Exception::Validation::BadArguments::InvalidJSON gettext("Invalid json in param '%s'\n%s",
                'search_json', $_[0]->message());
        };
    } else {
        my $search_param = $self->controller->request->param('search');

        if (defined($search_param) && $search_param =~ /^\s*$/) {
            $search_param = undef;
        }

        $self->{'search'}{'text'} = $search_param;

        try {
            $self->{'search'}{'data'} = $self->model->get_db_filter($search_param, type => 'json_data');
        }
        catch Exception::DBManager::Grammar with {
            $self->{'search'}{'error'} = $_[0]->message();
        }
    }
}

sub _get_vo_uri_params {
    my ($self, %opts) = @_;

    my %ignore_fields = map {$_ => TRUE} @{$opts{'ignore'} // []}, keys(%{$opts{'replace'} // {}});

    my %fields = map {$_ => $self->$_} grep {!$ignore_fields{$_}} qw(sort sortdesc page per_page);
    $fields{'search_json'} = to_json($self->search->{'data'})
      if !$ignore_fields{'search_json'} && $self->search->{'data'};

    $fields{'deleted'} = TRUE if $self->{'trash'} && $self->controller->request->param('deleted');

    push_hs(%fields, $opts{'replace'}) if exists($opts{'replace'});

    return \%fields if exists($opts{'as_hash'});

    return join(
        $self->controller->get_option('link_param_separator', '&amp;'),
        map {uri_escape($_) . '=' . uri_escape($fields{$_} // '')} keys(%fields)
    );
}

sub _is_positive_integer {
    my ($self, $scalar) = @_;

    my $result = defined($scalar)
      && $scalar =~ /^[1-9][0-9]*$/;

    return $result;
}

sub _per_page_is_correct {
    my ($self, $per_page) = @_;

    my $per_page_min = 1;
    my $per_page_max = 100;

    my $result =
         defined($per_page)
      && looks_like_number($per_page)
      && $per_page >= $per_page_min
      && $per_page <= $per_page_max;

    return $result;
}

TRUE;
