package WebInterface::HTTPS;

use qbit;

=head2 get_https_url

Возвращает скаляр с https адресом текущей страницы.

Метод правильно отрабатывает ситуацию когда это беты (на которых https
работают на порту 84NN).

Можно использовать:

    my $url = $webapplication->get_https_url();

    # Это вернет что-то вроде
    # https://partner.yandex.ru

Или по аналогии с методом url() из фреймворка:

    my $url = $webapplication->get_https_url(no_uri => TRUE);

    # Это вернет что-то вроде
    # https://partner.yandex.ru/dashboard
    # https://partner.yandex.ru/dashboard?some_param=12

=cut

sub get_https_url {
    my ($self, %opts) = @_;

    if ($self->request->scheme() eq 'https') {
        return $self->request->url(%opts);
    } elsif ($self->request->scheme() eq 'http') {

        my $port_addition = '';

        if ($self->request->server_port() != 80) {
            $port_addition = ":" . ($self->request->server_port() + 400);
        }

        my $url = "https://" . $self->request->server_name() . $port_addition;

        unless ($opts{'no_uri'}) {
            $url .= $self->request->uri();
            $url .= '?' . $self->request->query_string() if $self->request->query_string();
        }

        return $url;

    } else {
        throw gettext("Got incorrect scheme.");
    }
}

TRUE;
