
=encoding UTF-8
=cut

=head1 Название

Yandex::Utils - общие сабы для инфраструктуры Яндекса.

=cut

package Yandex::Utils;

use strict;
use warnings;

use base qw( Exporter );
our @EXPORT = qw(get_yandex_domain);

=head1 Методы

=head2 get_yandex_domain

    get_yandex_domain('beta.partner.yandex.ru');     # yandex.ru
    get_yandex_domain('beta.partner.yandex.com.tr'); # yandex.com.tr
    get_yandex_domain('http://beta.partner.yandex.ru:8062/settings');   # yandex.ru

=cut

sub get_yandex_domain {
    my ($server_name) = @_;
    $server_name =~ m{(yandex\.(:?ru|ua|com|com\.tr))(:?\:\d+)?(:?/.*)?$};
    return $1 ? $1 : '';
}

# SEE
# https://st.yandex-team.ru/PI-13802#5bfcfb159e654d001be511cc
# https://a.yandex-team.ru/arc/trunk/arcadia/yabs/basic_packages/yabs-base-modules/Yabs/Funcs.pm?rev=2897192#L1408
sub md5int($) {
    my $str = shift;
    my @ar  = unpack("N4", Digest::MD5::md5($str));
    my $hig = $ar[1] ^ $ar[3];
    my $low = $ar[0] ^ $ar[2];
    return ($hig << 32 | $low);
}

1;
