/* Не катить, попросить blizzard */

ALTER TABLE `context_on_site_adblock_action_log` DROP FOREIGN KEY `_context_on_site_adblock_action_log_ibfk_2`;

CREATE TABLE IF NOT EXISTS `context_on_site_adblock_tmp` (
    `page_id` int(10) unsigned NOT NULL DEFAULT '0',
    `id` int(10) unsigned NOT NULL,
    `caption` varchar(255) NOT NULL DEFAULT '',
    `comment` text,
    `direct_block` varchar(32) NOT NULL,
    `limit` int(10) unsigned DEFAULT NULL,
    `multistate` bigint(20) unsigned NOT NULL DEFAULT '0',
    `strategy` smallint(5) unsigned NOT NULL DEFAULT '1',
    `mincpm` smallint(5) unsigned DEFAULT NULL,
    `is_custom_bk_data` tinyint(1) NOT NULL DEFAULT '0',
    `bk_data` mediumtext,
    `show_video` tinyint(1) NOT NULL DEFAULT '0',
    PRIMARY KEY (`page_id`,`id`),
    KEY `context_on_site_adblock_tmp__id` (`id`),
    CONSTRAINT `_context_on_site_adblock_tmp_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `context_on_site_campaign` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

START TRANSACTION;

/* Дампим блоки */

INSERT INTO
    `context_on_site_adblock_tmp`
(
    `page_id`,
    `id`,
    `caption`,
    `comment`,
    `direct_block`,
    `limit`,
    `multistate`,
    `strategy`,
    `mincpm`,
    `is_custom_bk_data`,
    `bk_data`,
    `show_video`
) SELECT
    `page_id`,
    `id`,
    `caption`,
    `comment`,
    `direct_block`,
    `limit`,
    `multistate`,
    `strategy`,
    `mincpm`,
    `is_custom_bk_data`,
    `bk_data`,
    `show_video`
FROM
    `context_on_site_adblock`;

/* Мигрируем блоки */

INSERT INTO
    `context_on_site_rtb`
(
    campaign_id,
    id,
    model,
    unique_id,
    create_date,
    caption,
    multistate,
    strategy,
    mincpm,
    is_custom_bk_data,
    bk_data,
    show_video,
    from_trigger,
    opts
) SELECT
    page_id,
    id,
    'context_on_site_rtb',
    id | (page_id << 23) | (0 << 55),
    NOW(),
    caption,
    multistate,
    strategy,
    mincpm,
    is_custom_bk_data,
    bk_data,
    show_video,
    1,
    '{"adblock_block": true}'
FROM
    `context_on_site_adblock`;

/* Мигригуем логи */

INSERT INTO
    `context_on_site_rtb_action_log`
(
    `dt`,
    `user_id`,
    `elem_campaign_id`,
    `elem_id`,
    `old_multistate`,
    `action`,
    `new_multistate`,
    `opts`,
    `comment`
) SELECT
    `dt`,
    `user_id`,
    `elem_page_id`,
    `elem_id`,
    `old_multistate`,
    `action`,
    `new_multistate`,
    `opts`,
    `comment`
FROM
    `context_on_site_adblock_action_log`;

/* Добавляем дизайны */

INSERT INTO
    `design_templates`
(
    page_id,
    block_id,
    caption,
    order_num,
    opts,
    update_time,
    multistate,
    type
) SELECT
    page_id,
    id,
    'Исходный дизайн',
    0,
    CONCAT('{"stat_last_date": "1000-01-01 00:00:00.000000", "design_settings": {"name": "vertical", "limit": ', `limit`,'}, "is_custom_format_direct": "0"}'),
    NOW(),
    0,
    'tga'
FROM
    `context_on_site_adblock`;

/* Добавляем размеры */

INSERT INTO
    `media_sizes`
(
    `page_id`,
    `block_id`,
    `type`
) SELECT
    `page_id`,
    `id`,
    '240x400'
FROM
    `context_on_site_adblock`;

/* Удаляем блоки из старой таблицы */

DELETE FROM `context_on_site_adblock`;

COMMIT;
