update outdoor_block
set multistate = multistate | 8 | 1
where (outdoor_block.page_id, outdoor_block.id) in (
select all_blocks.page_id, all_blocks.id
from all_blocks
join outdoor on outdoor.page_id = all_blocks.page_id
where all_blocks.model = 'outdoor_block' and
(outdoor.multistate & 4) and      /* page deleted */
(not (all_blocks.multistate & 1)) /* block NOT deleted */
);

update indoor_block
set multistate = multistate | 8 | 1
where (indoor_block.page_id, indoor_block.id) in (
select all_blocks.page_id, all_blocks.id
from all_blocks
join indoor on indoor.page_id = all_blocks.page_id
where all_blocks.model = 'indoor_block' and
(indoor.multistate & 4) and      /* page deleted */
(not (all_blocks.multistate & 1)) /* block NOT deleted */
);