#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;
use PiConstants qw($BOOKMAKER_FLAG_ID);
use Utils::ScriptWrapper;

my $LIMIT = 1_000;

run(
    sub {
        my ($app, $opts) = @_;

        foreach my $model_name (sort @{$app->product_manager->get_page_model_accessors()}) {
            print logstr sprintf('Model: %s', $model_name);
            my $model        = $app->$model_name;
            my $page_id_name = $model->get_page_id_field_name();
            my $pk           = $model->partner_db_table->primary_key();
            my $need_filters = ($model->DOES('Application::Model::Role::Has::Filters') ? TRUE : FALSE);
            my $n            = 0;
            my $offset       = 0;
            while (TRUE) {
                my $data = $model->get_all(
                    fields   => $pk,
                    filter   => {$page_id_name => undef},
                    order_by => $pk,
                    limit    => $LIMIT,
                    ($opts->{dry_run} ? (offset => $offset) : ()),
                );
                my $count = scalar(@$data);
                last unless $count;
                print logstr sprintf('Model: %s, Iteration: [%d .. %d], count: %d',
                    $model_name, $offset, $LIMIT + $offset - 1, $count);
                $offset += $count;
                print logstr 'Data:', $data;
                unless ($opts->{dry_run}) {
                    foreach my $page (@$data) {
                        $model->partner_db->transaction(
                            sub {
                                my $page_id = $app->api_utils_partner2->get_next_page_id();
                                print logstr $page, '=>', $page_id;
                                $model->partner_db_table()->edit($page, {$page_id_name => $page_id});
                                $model->filters->update($page_id, [$BOOKMAKER_FLAG_ID]) if ($need_filters);
                            }
                        );
                    }
                }
            }
        }
    }
   );
