#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт правит cpm в поле geo для всех моделей

=head1 USAGE

  perl -I./lib ./migrations/after_release/PI-16446_fix_cpm_in_geo.pl
  perl -I./lib ./migrations/after_release/PI-16446_fix_cpm_in_geo.pl --accessor=mobile_app_rtb --dry
  perl -I./lib ./migrations/after_release/PI-16446_fix_cpm_in_geo.pl --page_ids=351913,386013 --dry

=head1 OPTIONS

  accessor - Аксессор модели
  page_ids - Список ID площадок через запятую (необязательный)

=cut

use qbit;

use Utils::ScriptWrapper;

use PiConstants qw($MAX_CPM);

my $LIMIT = 1000;

sub args {
    my ($opts) = @_;

    return (
        'accessor:s' => \$opts->{'accessor'},
        'page_ids:s' => \$opts->{'page_ids'},
        'dry!'       => \$opts->{'dry'}
    );
}

run(
    sub {
        my ($app, $opts) = @_;

        my $dry = $opts->{'dry'};

        my @accessors = ();
        if ($opts->{'accessor'}) {
            push(@accessors, $opts->{'accessor'});
        } else {
            @accessors =
              grep {$app->$_->DOES('Application::Model::Role::Has::Geo')}
              @{$app->product_manager->get_block_model_accessors()};
        }

        my $page_ids = [];
        $page_ids = [split(/,/, $opts->{'page_ids'})] if defined($opts->{'page_ids'});

        foreach my $accessor (@accessors) {
            print logstr('MODEL:', $accessor);

            my $page_id_field_name = $app->$accessor->get_page_id_field_name();

            my $offset = 0;
            my $blocks = [];
            do {
                $blocks = $app->$accessor->get_all(
                    fields => [qw(page_id id data_geo)],
                    (@$page_ids ? (filter => {page_id => $page_ids}) : ()),
                    offset => $offset,
                    limit  => $LIMIT
                );

                foreach my $block (@$blocks) {
                    if ($block->{'data_geo'} && @{$block->{'data_geo'}}) {
                        my $data_geo    = clone($block->{'data_geo'});
                        my $need_update = FALSE;
                        foreach my $row (@$data_geo) {
                            if (defined($row->{'cpm'}) && ($row->{'cpm'} > $MAX_CPM)) {
                                $need_update = TRUE;
                                $row->{'cpm'} = $MAX_CPM;
                            }
                        }

                        if ($need_update) {
                            print logstr('UPDATE BLOCK:', $block);

                            print logstr('SET GEO:', $data_geo);

                            unless ($dry) {
                                $app->partner_db->$accessor->edit(
                                    {$page_id_field_name => $block->{'page_id'}, id => $block->{'id'}},
                                    {geo                 => to_json($data_geo)});
                            }
                        }
                    }
                }

                $offset += $LIMIT;
            } while (@$blocks == $LIMIT);
        }
    }
   );
