#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт правит маппит тематики tnc в шфи для всех пресетов

=head1 USAGE

  perl -I./lib ./migrations/after_release/PI-18672_picategories_for_block_preset.pl [--commit]

=head1 OPTIONS

  commit - применить изменения

=cut

use lib::abs qw(../../lib);

use qbit;

use Utils::ScriptWrapper;

sub main {
    my ($app, $opts) = @_;

    my $tmp_rights = $app->add_all_tmp_rights();
    my $commit     = $opts->{commit};

    my $presets = $app->block_presets;

    my $graph = $presets->get_multistates_graph_definition();
    for my $action (@{$graph->{'multistate_actions'}}) {
        if ($action->{'action'} eq 'edit') {
            # Разрешаем редактировать из любого статуса
            $action->{'from'} = '__EMPTY__ or not __EMPTY__';
            last;
        }
    }
    $presets->multistates_graph($graph);

    my $list = $presets->get_all(fields => ["id", "settings", "multistate"]);
    foreach my $preset (@$list) {
        print logstr('PRESET:', $preset);
        $presets->do_action($preset->{id}, "edit", settings => $preset->{settings}) if $commit;
    }
}

run(\&main);
