/*
  bit  0     value  name
  ------------------------------
  0          1      working
  1          2      stopped
  2          4      deleted
  3          8      need_update
  4          16     updating
  5          32     read_only
  6          64     protected
  7          128    check_statistics
  8          256    balance_registered
  9          512    need_approve
  10         1024   approved
  11         2048   rejected
  12         4096   blocked
  13         8192   testing
*/

UPDATE
    `indoor`
SET
    `multistate` = `multistate` & ~512
WHERE
    `multistate` & 8192
;

UPDATE
    `outdoor`
SET
    `multistate` = `multistate` & ~512
WHERE
    `multistate` & 8192
;

/*
  bit  0     value  name
  ------------------------------
  0          1      deleted
  1          2      working
  2          4      check_statistics
  3          8      deleted_with_page
  4          16     need_update
  5          32     updating
  6          64     need_approve
  7          128    approved
  8          256    rejected
  9          512    blocked
  10         1024   testing
*/

UPDATE
    `indoor_block`
SET
    `multistate` = `multistate` & ~64
WHERE
    `multistate` & 1024
;

UPDATE
    `outdoor_block`
SET
    `multistate` = `multistate` & ~64
WHERE
    `multistate` & 1024
;
