#!/usr/bin/perl

use lib::abs qw( ../../lib );

use qbit;

use Utils::ScriptWrapper;

my $chunk = 1000;
run(
    sub {
        my ($app, $opts) = @_;

        my @video_models = (
            qw(
              video_an_site_instream
              video_an_site_inpage
              video_an_site_fullscreen
              )
        );

        for my $model (@video_models) {
            my $blocks;
            my @blocks_to_update;
            my $i = 0;
            do {
                $blocks = $app->partner_db->$model->get_all(
                    fields   => [qw(page_id id category_id category_path)],
                    offset   => $i * $chunk,
                    limit    => $chunk,
                    order_by => [qw(create_date page_id id)]
                );
                for my $block (@$blocks) {
                    my $category_path =
                      $app->$model->get_path_by_category_id($block->{'page_id'}, $block->{'category_id'});
                    if ($category_path ne ($block->{'category_path'} // '')) {
                        print logstr '-', $block;
                        $block->{'category_path'} = $category_path;
                        print logstr '+', $block;
                        push @blocks_to_update, $block;
                    }
                }
                $i += 1;
            } while (@$blocks);

            if (@blocks_to_update) {
                $app->partner_db->$model->add_multi(\@blocks_to_update, duplicate_update => 1);
            }
        }
    }
   );
