#!/usr/bin/perl

use lib::abs qw( ../../lib );

use qbit;

use Utils::ScriptWrapper;

my @MODELS = qw(context_on_site_rtb internal_context_on_site_rtb);
run(
    sub {
        my ($app, $opts) = @_;

        if ($opts->{rollback}) {
            my $file = $opts->{rollback};
            die logstr 'Incorrect file name for rollback', $file unless -f $file;
            my $fh;
            if (open($fh, '<', $file)) {
                my $line;
                while (defined($line = <$fh>)) {
                    if ($line =~ /\s+-\s+before\s+(\S+)\s+(.+)$/) {
                        my $model_name = $1;
                        my $block      = from_json $2;
                        print logstr rollback => $model_name => $block;
                        $app->$model_name->do_action($block, edit => dsps => $block->{dsps}) unless $opts->{dry_run};
                    }
                }
                close $fh;
            } else {
                die logstr 'Can\'t open', $file;
            }
        } else {
            for my $model_name (@MODELS) {
                my $model      = $app->$model_name;
                my @video_dsps = $model->get_video_dsp_list();
                my $blocks     = $model->get_all(
                    fields => [$model->get_page_id_field_name(), qw(dsps id)],
                    filter => [
                        AND => [
                            {is_custom_bk_data => 0},
                            {multistate        => $model->get_multistate_by_action('edit')},
                            {show_video        => 1},
                        ]
                    ],
                );
                print logstr model => $model_name, count => scalar @$blocks;
                for my $block (@$blocks) {
                    print logstr before => $model_name => $block;
                    $model->do_action($block, edit => dsps => array_uniq($block->{dsps}, @video_dsps))
                      unless $opts->{dry_run};
                }
            }
        }
    }
   );
