
DROP PROCEDURE IF EXISTS tmp_request;
DROP PROCEDURE IF EXISTS tmp_copy_related_data;
DROP PROCEDURE IF EXISTS tmp_copy_data;

delimiter //

CREATE PROCEDURE tmp_request (request VARCHAR(1024))
LANGUAGE SQL
BEGIN
    SET @request = request;
    prepare stmt from @request;
    execute stmt;
    deallocate prepare stmt;
END//

CREATE PROCEDURE tmp_copy_related_data (tbl VARCHAR(100), field VARCHAR(100), base_tbl VARCHAR(100), page_id_name VARCHAR(100))
LANGUAGE SQL
BEGIN
    SELECT CONCAT('    ', NOW(), ' ', tbl) AS '';
    CALL tmp_request(CONCAT('
        UPDATE
            `', tbl, '` AS `t`
        JOIN
            `', base_tbl, '` AS `bt`
                ON `bt`.`id` = `t`.`', field, '`
        SET
            `t`.`', field, '` = `bt`.`', page_id_name, '`
    '));
END//

CREATE PROCEDURE tmp_copy_data (tbl VARCHAR(100), page_id_name VARCHAR(100))
LANGUAGE SQL
BEGIN
    SELECT CONCAT('    ', NOW(), ' alter ', tbl) AS '';
    CALL tmp_request(CONCAT('
        ALTER TABLE
            `', tbl, '`
        MODIFY COLUMN
            `id` int(10) UNSIGNED NOT NULL
    '));
    SELECT CONCAT('    ', NOW(), ' ', tbl) AS '';
    CALL tmp_request(CONCAT('
        UPDATE
            `', tbl, '`
        SET
            `id` = `', page_id_name, '`
    '));
END//

delimiter ;

-- context_on_site_campaign
SELECT CONCAT(NOW(), ' context_on_site_campaign') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    call tmp_copy_related_data('context_on_site_campaign_action_log',  'elem_id',     'context_on_site_campaign', 'page_id');
    call tmp_copy_related_data('context_on_site_campaign_banner_lang', 'campaign_id', 'context_on_site_campaign', 'page_id');
    call tmp_copy_related_data('context_on_site_mirrors',              'campaign_id', 'context_on_site_campaign', 'page_id');
    call tmp_copy_data('context_on_site_campaign', 'page_id');
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE context_on_site_campaign, context_on_site_campaign_action_log, context_on_site_campaign_banner_lang, context_on_site_mirrors;
COMMIT;

-- search_on_site_campaign
SELECT CONCAT(NOW(), ' search_on_site_campaign') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    call tmp_copy_related_data('search_on_site_campaign_action_log',  'elem_id',     'search_on_site_campaign', 'page_id');
    call tmp_copy_related_data('search_on_site_campaign_banner_lang', 'campaign_id', 'search_on_site_campaign', 'page_id');
    call tmp_copy_related_data('search_on_site_mirrors',              'campaign_id', 'search_on_site_campaign', 'page_id');
    call tmp_copy_data('search_on_site_campaign', 'page_id');
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE search_on_site_campaign, search_on_site_campaign_action_log, search_on_site_campaign_banner_lang, search_on_site_mirrors;
COMMIT;

-- mobile_app_settings
SELECT CONCAT(NOW(), ' mobile_app_settings') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    call tmp_copy_related_data('mobile_app_settings_action_log', 'elem_id', 'mobile_app_settings', 'context_page_id');
    call tmp_copy_data('mobile_app_settings', 'context_page_id');
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE mobile_app_settings, mobile_app_settings_action_log;
COMMIT;

-- indoor
SELECT CONCAT(NOW(), ' indoor') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    SELECT CONCAT('    ', NOW(), ' alter indoor_action_log') AS '';
    ALTER TABLE `indoor_action_log` DROP FOREIGN KEY `indoor_action_log_ibfk_2`;
    ALTER TABLE `indoor_action_log` MODIFY COLUMN `elem_id` int(10) UNSIGNED NOT NULL;
    call tmp_copy_related_data('indoor_action_log', 'elem_id', 'indoor', 'page_id');
    call tmp_copy_data('indoor', 'page_id');
    ALTER TABLE `indoor_action_log` ADD CONSTRAINT `indoor_action_log_ibfk_2` FOREIGN KEY (`elem_id`) REFERENCES `indoor` (`id`);
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE indoor, indoor_action_log;
COMMIT;

-- outdoor
SELECT CONCAT(NOW(), ' outdoor') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    SELECT CONCAT('    ', NOW(), ' alter outdoor_action_log') AS '';
    ALTER TABLE `outdoor_action_log` DROP FOREIGN KEY `outdoor_action_log_ibfk_2`;
    ALTER TABLE `outdoor_action_log` MODIFY COLUMN `elem_id` int(10) UNSIGNED NOT NULL;
    call tmp_copy_related_data('outdoor_action_log', 'elem_id', 'outdoor', 'page_id');
    call tmp_copy_data('outdoor', 'page_id');
    ALTER TABLE `outdoor_action_log` ADD CONSTRAINT `outdoor_action_log_ibfk_2` FOREIGN KEY (`elem_id`) REFERENCES `outdoor` (`id`);
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE outdoor, outdoor_action_log;
COMMIT;

-- ssp_context_on_site_campaign
SELECT CONCAT(NOW(), ' ssp_context_on_site_campaign') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    call tmp_copy_related_data('ssp_context_on_site_campaign_action_log', 'elem_id',        'ssp_context_on_site_campaign', 'page_id');
    call tmp_copy_related_data('ssp_context_on_site_campaign_mirrors',    'campaign_id',    'ssp_context_on_site_campaign', 'page_id');
    call tmp_copy_related_data('ssp_link_context_rtb',                    'context_rtb_id', 'ssp_context_on_site_campaign', 'page_id');
    call tmp_copy_data('ssp_context_on_site_campaign', 'page_id');
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE ssp_context_on_site_campaign, ssp_context_on_site_campaign_action_log, ssp_context_on_site_campaign_mirrors, ssp_link_context_rtb;
COMMIT;

-- ssp_mobile_app_settings
SELECT CONCAT(NOW(), ' ssp_mobile_app_settings') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    call tmp_copy_related_data('ssp_link_mobile_app',                'mobile_app_id', 'ssp_mobile_app_settings', 'page_id');
    call tmp_copy_related_data('ssp_mobile_app_settings_action_log', 'elem_id',       'ssp_mobile_app_settings', 'page_id');
    call tmp_copy_related_data('ssp_mobile_app_settings_mirrors',    'campaign_id',   'ssp_mobile_app_settings', 'page_id');
    call tmp_copy_data('ssp_mobile_app_settings', 'page_id');
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE ssp_mobile_app_settings, ssp_link_mobile_app, ssp_mobile_app_settings_action_log, ssp_mobile_app_settings_mirrors;
COMMIT;

-- ssp_video_an_site
SELECT CONCAT(NOW(), ' ssp_video_an_site') AS '';
START TRANSACTION;
    SET FOREIGN_KEY_CHECKS=0;
    call tmp_copy_related_data('ssp_link_video_app',           'video_app_id',  'ssp_video_an_site', 'page_id');
    call tmp_copy_related_data('ssp_video_an_site_action_log', 'elem_id',       'ssp_video_an_site', 'page_id');
    call tmp_copy_related_data('ssp_video_an_site_mirrors',    'campaign_id',   'ssp_video_an_site', 'page_id');
    call tmp_copy_data('ssp_video_an_site', 'page_id');
    SET FOREIGN_KEY_CHECKS=1;
    ANALYZE TABLE ssp_video_an_site, ssp_link_video_app, ssp_video_an_site_action_log, ssp_video_an_site_mirrors;
COMMIT;

SELECT CONCAT(NOW(), ' clean') AS '';
DROP PROCEDURE IF EXISTS tmp_copy_related_data;
DROP PROCEDURE IF EXISTS tmp_copy_data;
DROP PROCEDURE IF EXISTS tmp_request;

DELETE FROM `kv_store` WHERE `key` = 'campaign_next_id';

SELECT CONCAT(NOW(), ' END') AS '';

/*

select max(page_id) from all_pages;
+--------------+
| max(page_id) |
+--------------+
|       518392 |
+--------------+
1 row in set (0.02 sec)

select max(id) from context_on_site_campaign;
+---------+
| max(id) |
+---------+
|  209329 |
+---------+
1 row in set (0.02 sec)

select max(id) from search_on_site_campaign;
+---------+
| max(id) |
+---------+
|  209326 |
+---------+
1 row in set (0.02 sec)

select max(id) from mobile_app_settings;
+---------+
| max(id) |
+---------+
|   13309 |
+---------+
1 row in set (0.02 sec)

select max(id) from indoor;
+---------+
| max(id) |
+---------+
|    2001 |
+---------+
1 row in set (0.02 sec)

select max(id) from outdoor;
+---------+
| max(id) |
+---------+
|     116 |
+---------+
1 row in set (0.02 sec)

select max(id) from ssp_context_on_site_campaign;
+---------+
| max(id) |
+---------+
|    2208 |
+---------+
1 row in set (0.02 sec)

select max(id) from ssp_mobile_app_settings;
+---------+
| max(id) |
+---------+
|   40974 |
+---------+
1 row in set (0.02 sec)

select count(id) from ssp_video_an_site;
+-----------+
| count(id) |
+-----------+
|         0 |
+-----------+
1 row in set (0.02 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='context_on_site_campaign' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: context_on_site_campaign_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: context_on_site_campaign_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: context_on_site_campaign
       REFERENCED_COLUMN_NAME: id
*************************** 2. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: context_on_site_campaign_banner_lang_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: context_on_site_campaign_banner_lang
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: context_on_site_campaign
       REFERENCED_COLUMN_NAME: id
*************************** 3. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: context_on_site_mirrors_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: context_on_site_mirrors
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: context_on_site_campaign
       REFERENCED_COLUMN_NAME: id
3 rows in set (0.06 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='search_on_site_campaign' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: search_on_site_campaign_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: search_on_site_campaign_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: search_on_site_campaign
       REFERENCED_COLUMN_NAME: id
*************************** 2. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: search_on_site_campaign_banner_lang_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: search_on_site_campaign_banner_lang
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: search_on_site_campaign
       REFERENCED_COLUMN_NAME: id
*************************** 3. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: search_on_site_mirrors_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: search_on_site_mirrors
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: search_on_site_campaign
       REFERENCED_COLUMN_NAME: id
3 rows in set (0.06 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='mobile_app_settings' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: fk_mobile_app_settings_action_log__elem_id___mobile_app_settings
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: mobile_app_settings_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: mobile_app_settings
       REFERENCED_COLUMN_NAME: id
1 row in set (0.08 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='indoor' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: indoor_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: indoor_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: indoor
       REFERENCED_COLUMN_NAME: id
1 row in set (0.06 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='outdoor' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: outdoor_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: outdoor_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: outdoor
       REFERENCED_COLUMN_NAME: id
1 row in set (0.07 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='ssp_context_on_site_campaign' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_context_on_site_campaign_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_context_on_site_campaign_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_context_on_site_campaign
       REFERENCED_COLUMN_NAME: id
*************************** 2. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_context_on_site_campaign_mirrors_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_context_on_site_campaign_mirrors
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_context_on_site_campaign
       REFERENCED_COLUMN_NAME: id
*************************** 3. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_link_context_rtb_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_link_context_rtb
                  COLUMN_NAME: context_rtb_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_context_on_site_campaign
       REFERENCED_COLUMN_NAME: id
3 rows in set (0.06 sec)


mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='ssp_mobile_app_settings' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_link_mobile_app_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_link_mobile_app
                  COLUMN_NAME: mobile_app_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_mobile_app_settings
       REFERENCED_COLUMN_NAME: id
*************************** 2. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_mobile_app_settings_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_mobile_app_settings_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_mobile_app_settings
       REFERENCED_COLUMN_NAME: id
*************************** 3. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_mobile_app_settings_mirrors_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_mobile_app_settings_mirrors
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_mobile_app_settings
       REFERENCED_COLUMN_NAME: id
3 rows in set (0.06 sec)

mysql> select * from information_schema.key_column_usage where REFERENCED_TABLE_NAME='ssp_video_an_site' and REFERENCED_COLUMN_NAME='id'\G
*************************** 1. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_link_video_app_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_link_video_app
                  COLUMN_NAME: video_app_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_video_an_site
       REFERENCED_COLUMN_NAME: id
*************************** 2. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_video_an_site_action_log_ibfk_2
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_video_an_site_action_log
                  COLUMN_NAME: elem_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_video_an_site
       REFERENCED_COLUMN_NAME: id
*************************** 3. row ***************************
           CONSTRAINT_CATALOG: def
            CONSTRAINT_SCHEMA: partner
              CONSTRAINT_NAME: ssp_video_an_site_mirrors_ibfk_1
                TABLE_CATALOG: def
                 TABLE_SCHEMA: partner
                   TABLE_NAME: ssp_video_an_site_mirrors
                  COLUMN_NAME: campaign_id
             ORDINAL_POSITION: 1
POSITION_IN_UNIQUE_CONSTRAINT: 1
      REFERENCED_TABLE_SCHEMA: partner
        REFERENCED_TABLE_NAME: ssp_video_an_site
       REFERENCED_COLUMN_NAME: id
3 rows in set (0.06 sec)

*/
