
/*

Выставление флага переотправки для требуемых блоков

./bin/explain_multistate.pl --accessor=video_an_site_inpage --multistate=0 --no-actions
Bits:
  0 - (Новый)

  bit  0     value  name
  ------------------------------
  0          1      deleted
  1          2      working
  2          4      check_statistics
  3          8      deleted_with_page
  4          16     need_update
  5          32     updating

action    => 'set_need_update',
from      => '__EMPTY__ or not __EMPTY__',
set_flags => ['need_update'],

*/

UPDATE
    `video_an_site_inpage`
SET
    `multistate` = `multistate` | 16
WHERE
    `count_positions` > 1
;

/*

Выставление флага переотправки для пейджей с требуемыми блоками

./bin/explain_multistate.pl --accessor=video_an_site --multistate=0 --no-actions
Bits:
  0 - (New)

  bit  0     value  name
  ------------------------------
  0          1      working
  1          2      testing
  2          4      stopped
  3          8      deleted
  4          16     check_statistics
  5          32     protected
  6          64     need_update
  7          128    updating

action    => 'set_need_update',
from      => 'not (deleted or protected)',
set_flags => ['need_update'],

*/

UPDATE
    `video_an_site`
SET
    `multistate` = `multistate` | 64
WHERE
    NOT
        (
            `multistate` & 8
        OR
            `multistate` & 32
        )
    AND
        `id` IN (
            SELECT
                `page_id`
            FROM
                `video_an_site_inpage`
            WHERE
                `count_positions` > 1
            GROUP BY
                1
        )
;

/*

Удаление более не нужного столбца

*/

ALTER TABLE
    `video_an_site_inpage`
DROP COLUMN
    `count_positions`,
ALGORITHM=INPLACE,
LOCK=NONE;
