#!/usr/bin/perl

use qbit;
use PiConstants qw(
  @AVAILABLE_COOPERATION_FORMS
  $SELFEMPLOYED_COOPERATION_FORM
  );
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $data = $app->partner_db->query->select(
            table  => $app->users->partner_db_table(),
            fields => [qw(id client_id)],
            filter => [{json_extract => ['opts', \'$.cooperation_form']} => '=' => \undef],
        )->get_all();

        my %cooperation_forms = map {$_ => TRUE} @AVAILABLE_COOPERATION_FORMS;
        foreach my $user (@$data) {
            if ($user->{client_id}) {
                try {
                    my $contracts = $app->documents->get_contracts(client_id => $user->{client_id});
                    if (@$contracts) {
                        my $contract = $contracts->[-1];
                        my $person   = $contract->{Person};
                        my $type     = $person->{type};
                        if ($type) {
                            $user->{person_type} = $type;
                            if ($cooperation_forms{$type}) {
                                $user->{inn} = $person->{inn};
                                print logstr 'Process user', $user;
                                $app->users->do_action(
                                    $user->{id}, 'edit',
                                    cooperation_form => $type,
                                    inn              => $person->{inn},
                                );
                            } else {
                                print logstr 'Unknown person type', $user;
                            }
                        }
                    }
                }
                catch {
                    print logstr 'Error while process user', $user, "$_[0]";
                };
            }
        }
    }
   );
