-- select design_templates to be updated: fullscreen, fullscreenDuration
select
    dt.id, opts->'$.design_settings', tt.*
from
    design_templates as dt
join (
    select
        t.page_id, t.block_id, t._fs, t._fd
    from (
        select
            design_templates.page_id,
            design_templates.block_id,
            design_templates.opts->>'$.design_settings.fullscreen' as _fs,
            max(design_templates.opts->>'$.design_settings.fullscreenDuration') as _fd
        from
            design_templates
        where
            design_templates.type = 'tga' and
            design_templates.multistate = 0 and
            design_templates.opts->>'$.design_settings.fullscreen' = 'true' and
            page_id in (select page_id from design_templates where type = 'media')
        group by page_id, block_id
    ) t
) tt on tt.page_id = dt.page_id and tt.block_id = dt.block_id
where dt.type = 'media';
-- update fullscreen, fullscreenDuration
update
    design_templates as dt
join (
    select
        t.page_id, t.block_id, t._fd
    from (
        select
            design_templates.page_id,
            design_templates.block_id,
            max(design_templates.opts->>'$.design_settings.fullscreenDuration') as _fd
        from
            design_templates
        where
            design_templates.type = 'tga' and
            design_templates.multistate = 0 and
            design_templates.opts->>'$.design_settings.fullscreen' = 'true' and
            page_id in (select page_id from design_templates where type = 'media')
        group by page_id, block_id
    ) t
) tt on tt.page_id = dt.page_id and tt.block_id = dt.block_id
set opts = (case
    when tt._fd is not null
    then json_set(opts, '$.design_settings.fullscreen', true, '$.design_settings.fullscreenDuration', tt._fd)
    else json_set(opts, '$.design_settings.fullscreen', true)
    end
)
where dt.type = 'media';

-- select design_templates to be updated: interscroller, interscrollerBgColor
select
    dt.id, opts->'$.design_settings', tt.*
from
    design_templates as dt
join (
    select
        t.page_id, t.block_id, t._is, t._isc
    from (
        select
            design_templates.page_id,
            design_templates.block_id,
            design_templates.opts->>'$.design_settings.interscroller' as _is,
            design_templates.opts->>'$.design_settings.interscrollerBgColor' as _isc
        from
            design_templates
        where
            design_templates.type = 'tga' and
            design_templates.multistate = 0 and
            design_templates.opts->>'$.design_settings.interscroller' = 'true' and
            page_id in (select page_id from design_templates where type = 'media')
        group by page_id, block_id
    ) t
) tt on tt.page_id = dt.page_id and tt.block_id = dt.block_id
where dt.type = 'media' and dt.opts->'$.design_settings.interscroller' is null;

-- update interscroller, interscrollerBgColor
update
    design_templates as dt
join (
    select
        t.page_id, t.block_id, t._isc
    from (
        select
            design_templates.page_id,
            design_templates.block_id,
            design_templates.opts->>'$.design_settings.interscrollerBgColor' as _isc
        from
            design_templates
        where
            design_templates.type = 'tga' and
            design_templates.multistate = 0 and
            design_templates.opts->>'$.design_settings.interscroller' = 'true' and
            page_id in (select page_id from design_templates where type = 'media')
        group by page_id, block_id
    ) t
) tt on tt.page_id = dt.page_id and tt.block_id = dt.block_id
set opts = (case
    when tt._isc is not null
    then json_set(opts, '$.design_settings.interscroller', true, '$.design_settings.interscrollerBgColor', tt._isc)
    else json_set(opts, '$.design_settings.interscroller', true)
    end
)
where dt.type = 'media' and dt.opts->'$.design_settings.interscroller' is null;
