#!/usr/bin/perl

use qbit;
use PiConstants qw(
  $AGGR_TUTBY
  );
use Utils::ScriptWrapper;

my %aggregator_id_map = (
    88415289  => 1226565,
    2728867   => 15397,
    198952652 => 2421750,
);

run(
    sub {
        my ($app, $opts) = @_;

        my $external_accessors = $app->product_manager->get_external_product_accessors();

        my $campaigns_query;
        foreach my $accessor (sort @$external_accessors) {
            my $model           = $app->$accessor;
            my $page_field_name = $model->get_page_id_field_name();

            my $sub_query = $app->partner_db->query->select(
                table  => $model->partner_db_table(),
                fields => {
                    page_id     => $page_field_name,
                    create_date => '',
                    owner_id    => ''
                },
                (
                    $model->get_multistate_by_name('balance_registered')
                    ? (filter => {multistate => $model->get_multistates_by_filter('balance_registered')})
                    : ()
                ),
            );

            if (defined($campaigns_query)) {
                $campaigns_query->union_all($sub_query);
            } else {
                $campaigns_query = $sub_query;
            }
        }

        my $pages = $app->partner_db->query->select(
            table  => $app->partner_db->legacy_billing_report,
            fields => {
                page_id  => '',
                start_dt => 'date_from',
                end_dt   => 'date_to',
                aggr_uid => 'aggregator_id'
            },
            filter => [aggregator_id => 'IN' => \[grep {$_ ne $AGGR_TUTBY->{user_id}} keys(%aggregator_id_map)]],
          )->union_all(
            $app->partner_db->query->select(
                table  => $app->partner_db->users,
                alias  => 'users',
                fields => [],
                filter => {is_tutby => 1},
              )->join(
                table  => $campaigns_query,
                alias  => 'campaigns',
                fields => {
                    page_id  => '',
                    start_dt => {DATE_FORMAT => ['create_date' => \'%Y-%m-%d']},
                    end_dt   => \undef,
                    aggr_uid => \$AGGR_TUTBY->{user_id},
                },
                join_on => [owner_id => '=' => {'id' => 'users'}],
              )
          )->get_all();

        $app->api_balance->register_aggregator_pages(
            [
                map {
                    $_->{aggregator_client_id} = $aggregator_id_map{$_->{aggr_uid}};
                    $_
                  } @$pages
            ]
        );
    }
   );
