
set @SITE_IDS=( SELECT group_concat(id order by id)  FROM site  WHERE domain='avito.dev' OR domain='ok.ru' OR domain='vk.com' OR domain='rambler.ru' OR domain='mail.ru' OR domain='youla.io' OR domain='avito.ru' OR domain='lenta.ru' OR domain='gazeta.ru' OR domain='gismeteo.ru' OR domain='rbc.ru' OR domain LIKE '%.devmail.ru' OR domain='eda.ru' OR domain='nightparty.ru' OR domain LIKE '%.afisha.ru' OR domain='mir.afisha.ru' OR domain='daily.afisha.ru' OR domain='m.gazeta.ru' OR domain='gazeta.ru' OR domain='lenta.ru' OR domain='motor.ru' OR domain='m.lenta.ru' OR domain='moslenta.ru' OR domain='secretmag.ru' OR domain='championat.com' OR domain='letidor.ru' OR domain='quto.ru' OR domain='wmj.ru' OR domain='indicator.ru' OR domain='ferra.ru' OR domain='rns.online' OR domain='m.passion.ru' OR domain='passion.ru' OR domain='m.moslenta.ru' OR domain='autorambler.ru' OR domain='livejournal.com' OR domain='rg.ru' );
select "Domain ids", @SITE_IDS;


set 	@PAGE_IDS=( SELECT group_concat(page_id order by page_id ) FROM all_pages WHERE domain_id in (@SITE_IDS) );
select "Page ids", @PAGE_IDS;


UPDATE `context_on_site_rtb`
SET    `limit` = 6
WHERE  `limit` in (3,4)
        AND `direct_block` = 'horizontal'
        AND `site_version` = 'desktop'
        AND `is_custom_format_direct` = 0
        AND campaign_id NOT IN (@PAGE_IDS);


UPDATE `context_on_site_campaign`
SET     multistate = multistate | 2048 /* need_update */
WHERE   page_id IN (

    SELECT DISTINCT campaign_id
    FROM   context_on_site_rtb
    where  `direct_block` = 'horizontal'
           AND `site_version` = 'desktop'
           AND `is_custom_format_direct` = 0
           AND `limit` = 6
);



UPDATE `internal_context_on_site_rtb`
SET    `limit` = 6
WHERE  `limit` in (3,4)
        AND `direct_block` = 'horizontal'
        AND `site_version` = 'desktop'
        AND `is_custom_format_direct` = 0
        AND campaign_id NOT IN (@PAGE_IDS);


UPDATE `internal_context_on_site_campaign`
SET     multistate = multistate | 256 /* need_update */
WHERE   id IN (

    SELECT DISTINCT campaign_id
    FROM   internal_context_on_site_rtb
    where  `direct_block` = 'horizontal'
           AND `site_version` = 'desktop'
           AND `is_custom_format_direct` = 0
           AND `limit` = 6
);
