#!/usr/bin/perl
#dependencies PI-24044_delete_feature_except_logins.sql

use qbit;
use Utils::ScriptWrapper;

run(\&main);

sub main {
    my ($app, $opts) = @_;
    my $users_with_feature = $app->user_features->get_all(
        fields => ['login'],
        filter => {feature => 'turbo_desktop_available'}
    );

    print logstr("FOUND_LOGIN", scalar @$users_with_feature);

    my $blocks = $app->context_on_site_rtb->get_all(
        fields => ['page_id', 'id', 'login', 'multistate', 'site_version', 'public_id', 'adfox_block'],
        filter => [
            AND => [
                {site_version => 'turbo_desktop'},
                ['login'      => 'NOT IN' => [map {$_->{login}} @$users_with_feature]],
                {multistate   => 'not deleted'},
            ]
        ],
        order_by => ['page_id'],
    );
    print logstr("FOUND_BLOCKS", scalar @$blocks);
    my $count = 0;
    my $error = 0;
    my $skip  = 0;

    for my $row (@$blocks) {
        if ($row->{adfox_block}) {
            print logstr("SKIP_ADFOX", $row->{public_id}, $row);
            $skip++;
            next;
        }
        try {
            $app->context_on_site_rtb->do_action($row->{public_id}, 'delete');
            print logstr("DELETE_BLOCK", $row->{public_id}, $row);
            $count++;
        }
        catch {
            my ($e) = @_;
            print logstr("DELETE_FAIL", $row, $e->message);
            $error++;
        };
    }

    print logstr("DELETED_BLOCKS", $count);
    print logstr("DELETE_ERROR",   $error);
    print logstr("ADFOX_BLOCKS",   $skip);
}

sub prepare_args {
    my ($opts) = @_;

    $opts->{ticket} = 'PI-24044';
}
