#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  ../../local/lib/perl5
  );

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $filter = $app->partner_db->filter();
        $filter->and(['multistate' => '=' => \$app->statistics_reports->get_multistates_by_filter('deleted')]);

        my $deleted_report_list = $app->partner_db->query->select(
            table  => $app->statistics_reports->partner_db_table(),
            fields => [qw(id)],
            filter => $filter,
        )->get_all();

        my %deleted_report_list = map {$_->{id} => 1} @$deleted_report_list;

        my $use_as_widget_list = $app->partner_db->widgets->get_all(fields => [qw(user_id json_widgets_settings)],);
        for my $widget (@$use_as_widget_list) {
            if (defined $widget->{json_widgets_settings}) {
                my @old_widgets = @{from_json($widget->{json_widgets_settings})};
                my @new_widgets = grep {
                         ($_->{accessor} ne 'widget_statistics')
                      || (defined $_->{settings}{report_id} && $_->{settings}{report_id} !~ /^\d+$/)
                      || ( defined $_->{settings}{report_id}
                        && $_->{settings}{report_id} =~ /^\d+$/
                        && !exists $deleted_report_list{$_->{settings}{report_id}})
                } @old_widgets;

                if (@old_widgets > @new_widgets) {
                    print logstr("removing deleted reports for user[$widget->{user_id}]:\n",
                        \@old_widgets, "\n", \@new_widgets);

                    unless ($opts->{dry_run}) {
                        $app->partner_db->widgets->edit($widget, {json_widgets_settings => to_json(\@new_widgets)});
                    }
                }
            }
        }
    }
   );
