/*
создаем временную таблицу
 */
create table `PI_24578_tmp` (`page_id` long,`block_id` int);

/*
заполняем
 */
insert into `PI_24578_tmp`
select `page_id`,`block_id`
from `block_dsps`
where `dsp_id` = 2563330
  and (`page_id`,`block_id`) in (
      select `context_page_id`,`id` from `mobile_app_rtb` where `block_type` = 'native'
  );

/*
 удаляем DSP с блоков
 */
delete from `block_dsps`
where
`dsp_id` = 2563330
and (`page_id`,`block_id`) in (select `page_id`,`block_id` from `PI_24578_tmp`);

/*
 ставим на переотправку
 */
update `mobile_app_settings`
set `multistate` = `multistate` | 512 /* need_update */
where
`context_page_id` in (
    select a.`context_page_id`
    from `mobile_app_rtb` as a
    join `PI_24578_tmp` as b on b.`page_id` = a.`context_page_id` and b.`block_id` = a.`id`
    where a.`multistate` & 2 /* working */
    )
and `multistate` & 1 /* working */
and `multistate` & 32 /* balance_registered */;

/*
 удаляем временную таблицу
 */
drop table `PI_24578_tmp`;
