#!/usr/bin/perl
use qbit;
use Utils::ScriptWrapper 'oneshot';

run(\&main);

sub prepare_args {
    my ($opts) = @_;

    $opts->{ticket} = 'PI-24890';
}

sub main {
    my ($app, $opts) = @_;

    make_model_gm($app, 'context_on_site_rtb',          $opts);
    make_model_gm($app, 'internal_context_on_site_rtb', $opts);
}

sub make_model_gm {
    my ($app, $model, $opts) = @_;
    my $sql = "
select
    campaign_id,id,bk_data
from $model
where is_custom_bk_data=1
  and multistate & 2
  and bk_data->'\$.AdTypeSet.\"video-motion\"' = 1
  and json_search(bk_data->'\$.RtbDesign.*.type','one','video') is not null";
    $sql .= " limit $opts->{limit}" if $opts->{limit};

    my $rtb = $app->partner_db->_get_all($sql);
    print logstr("FOUND", scalar(@$rtb));
    for my $row (@$rtb) {
        my $bk_data = from_json($row->{bk_data});
        $bk_data->{AdTypeSet}{'video-motion'} = 0;
        $app->$model->do_action($row, 'edit', bk_data => to_json($bk_data, pretty => TRUE));
        print logstr($app->$model->public_id_prefix . $row->{campaign_id} . '-' . $row->{id},
            from_json($row->{bk_data}));
    }
}
