#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Необходимо подключить прод БК (api_http_bk) и прод базу

=cut

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

my $START_DATE = '2016-07-01';

my @PRODUCTS = qw(
  context_on_site_rtb
  context_on_site_adfox
  mobile_app_rtb
  ssp_context_rtb
  internal_context_on_site_rtb
  internal_mobile_app_rtb
  );

my %PREFIX = (
    mobile_app_rtb          => 'mobile_rtb_block_direct_',
    internal_mobile_app_rtb => 'mobile_rtb_block_direct_',
    context_on_site_adfox   => 'adfox_block_direct_',
);

my $APP;

main();

sub main {
    $APP = Application->new();

    $APP->pre_run();

    $APP->set_cur_user({id => 0});
    no strict 'refs';
    no warnings 'redefine';
    *{'QBit::Application::check_rights'} = sub {TRUE};

    my $blocks = {};

    foreach my $p (@PRODUCTS) {
        my $page_field_name = $APP->$p->get_page_id_field_name();

        $blocks->{$p}{$_->{$page_field_name}}->{$_->{'id'}} = TRUE foreach @{
            $APP->$p->get_all(
                fields => [$page_field_name, 'id'],
                filter => ['AND', [[$page_field_name => 'IS NOT' => undef]]]
            )
          };
    }

    my $cur_date = curdate(oformat => 'db');
    my $date = $START_DATE;

    my ($dt, $page_id, $block_id, $dsp_id, $tag_id, $key);

    while ($date le $cur_date) {
        print "$date\n";

        my $data = {};

        foreach my $row (
            grep {$_->{'IsDSP'}} @{
                $APP->api_http_bk->get_direct_rtb_stat(
                    date_from => $date,
                    date_to   => $date,
                )
            }
          )
        {
            my $count = 0;
            foreach my $p (@PRODUCTS) {
                next unless exists($blocks->{$p}{$row->{'PageID'}}{$row->{'TagID'}});

                $dt       = $row->{'EventDate'};
                $page_id  = $row->{'PageID'};
                $block_id = $row->{'TagID'};
                $dsp_id   = 1;
                $tag_id   = 0;

                $key = "$dt|$page_id|$block_id|$dsp_id|$tag_id";

                my $prefix = $PREFIX{$p} // 'rtb_block_direct_';

                $data->{$p}{$key}{$prefix . 'clicks'} += $row->{'SumClicks'} - $row->{'SumBadClicks'};
                $data->{$p}{$key}{$prefix . 'shows'}  += $row->{'SumShows'} - $row->{'SumBadShows'};

                $count++;
            }

            throw 'Many products' if $count > 1;
        }

        foreach my $p (keys(%$data)) {
            foreach my $pk_string (keys(%{$data->{$p}})) {
                ($dt, $page_id, $block_id, $dsp_id, $tag_id) = split('\|', $pk_string);

                my $pk = [$dt, $page_id, $block_id, $dsp_id, 2, ($p ne 'ssp_context_rtb' ? $tag_id : ())];

                my $old_data =
                  $APP->$p->get_statistics_level->_get_stat_table->get($pk,
                    fields => [keys(%{$data->{$p}{$pk_string}})]);

                unless (defined($old_data)) {
                    print "Error: $p ($pk_string)\n";

                    next;
                }

                print "$p ($pk_string): "
                  . join(', ',
                    map {"$_: $old_data->{$_} -> $data->{$p}{$pk_string}{$_}"} keys(%{$data->{$p}{$pk_string}}))
                  . "\n";

                $APP->$p->get_statistics_level->_get_stat_table->edit($pk, $data->{$p}{$pk_string});
            }
        }

        $date = date_add($date, iformat => 'db', oformat => 'db', day => 1);
    }

    $APP->post_run();
}
