#!/usr/bin/perl

use qbit;
use Utils::ScriptWrapper;

run(
    sub {
        my ($app, $opts) = @_;

        my $dsps = $app->partner_db->query->select(
            table  => $app->partner_db->dsp,
            alias  => 'dsp',
            fields => {dsp_id => 'id'},
          )->join(
            table  => $app->partner_db->users,
            alias  => 'users',
            fields => {
                owner_id  => 'id',
                client_id => '',
            },
            join_on => [id => '=' => {'owner_id' => 'dsp'}],
          )->get_all();

        foreach my $dsp (@$dsps) {
            $app->dsp->_send_dsp_for_billing_to_lb($dsp->{dsp_id},
                {id => $dsp->{owner_id}, client_id => $dsp->{client_id}});
        }
    }
   );
