#dependencies PI-26564_drop_fk.sql

DROP TRIGGER IF EXISTS `external_rtb_insert`;
DELIMITER $$
CREATE TRIGGER external_rtb_insert
    BEFORE INSERT
    ON context_on_site_rtb
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0 AND NEW.model = 'internal_context_on_site_rtb')
    THEN
        SET NEW.from_trigger = 1;
        INSERT INTO internal_context_on_site_rtb (campaign_id, id, create_date, caption, multistate, geo, mincpm,
                                                  comment, is_custom_bk_data, bk_data, media_active, media_blocked, media_cpm, text_active, text_blocked,
                                                  text_cpm, opts, horizontal_align, alternative_code, blind, strategy, active, ex_direct, duplicate_direct,
                                                  show_video, site_version, adfox_block, video_active, video_blocked, video_cpm, from_trigger)
        VALUES (NEW.campaign_id, NEW.id, NEW.create_date, NEW.caption,
                NEW.multistate, NEW.geo, NEW.mincpm,
                NEW.comment, NEW.is_custom_bk_data, NEW.bk_data, NEW.media_active, NEW.media_blocked, NEW.media_cpm,
                NEW.text_active, NEW.text_blocked,
                NEW.text_cpm, NEW.opts, NEW.horizontal_align, NEW.alternative_code, NEW.blind, NEW.strategy, NEW.active,
                NEW.ex_direct, NEW.duplicate_direct,
                NEW.show_video, NEW.site_version, NEW.adfox_block, NEW.video_active,
                NEW.video_blocked, NEW.video_cpm, 1);
    END IF;
END; $$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_rtb_insert`;
DELIMITER $$
CREATE TRIGGER internal_rtb_insert
    BEFORE INSERT
    ON internal_context_on_site_rtb
    FOR EACH ROW
BEGIN
    DECLARE UNIQUE_ID BIGINT UNSIGNED;
    IF (NEW.from_trigger = 0)
    THEN
        SET NEW.from_trigger = 1;
        SET UNIQUE_ID = NEW.id | (NEW.campaign_id << 23) | (1 << 55);
        INSERT INTO context_on_site_rtb (campaign_id, id, model, create_date, caption, multistate, geo, mincpm,
                                         comment, is_custom_bk_data, bk_data, media_active, media_blocked, media_cpm,
                                         text_active, text_blocked,
                                         text_cpm, opts, horizontal_align, alternative_code, blind, strategy, active,
                                         ex_direct, duplicate_direct,
                                         show_video, site_version, adfox_block, video_active, video_blocked, video_cpm,
                                         unique_id, from_trigger)
        VALUES (NEW.campaign_id, NEW.id, 'internal_context_on_site_rtb', NEW.create_date, NEW.caption,
                NEW.multistate, NEW.geo, NEW.mincpm,
                NEW.comment, NEW.is_custom_bk_data, NEW.bk_data, NEW.media_active, NEW.media_blocked, NEW.media_cpm,
                NEW.text_active, NEW.text_blocked,
                NEW.text_cpm, NEW.opts, NEW.horizontal_align, NEW.alternative_code, NEW.blind, NEW.strategy, NEW.active,
                NEW.ex_direct, NEW.duplicate_direct,
                NEW.show_video, NEW.site_version, NEW.adfox_block, NEW.video_active,
                NEW.video_blocked, NEW.video_cpm,
                UNIQUE_ID, 1);
    END IF;
END; $$
DELIMITER ;

DROP TRIGGER IF EXISTS `external_rtb_update`;
DELIMITER $$
CREATE TRIGGER external_rtb_update
    BEFORE UPDATE
    ON context_on_site_rtb
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 1 AND NEW.model = 'internal_context_on_site_rtb')
        THEN
        UPDATE internal_context_on_site_rtb
        SET caption = NEW.caption, multistate = NEW.multistate, geo = NEW.geo, mincpm = NEW.mincpm,
            comment = NEW.comment, is_custom_bk_data = NEW.is_custom_bk_data, bk_data = NEW.bk_data,
            media_active = NEW.media_active, media_blocked = NEW.media_blocked, media_cpm = NEW.media_cpm,
            text_active = NEW.text_active, text_blocked = NEW.text_blocked, text_cpm = NEW.text_cpm,
            opts = NEW.opts, horizontal_align = NEW.horizontal_align,
            alternative_code = NEW.alternative_code, blind = NEW.blind, strategy = NEW.strategy,
            active = NEW.active, ex_direct = NEW.ex_direct, duplicate_direct = NEW.duplicate_direct,
            show_video = NEW.show_video, site_version = NEW.site_version, adfox_block = NEW.adfox_block,
            video_active = NEW.video_active, video_blocked = NEW.video_blocked, video_cpm = NEW.video_cpm,
            from_trigger = 2
        WHERE campaign_id = NEW.campaign_id AND id = NEW.id;
    ELSEIF (NEW.from_trigger = 2)
    THEN
        SET NEW.from_trigger = 1;
    END IF;
END; $$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_rtb_update`;
DELIMITER $$
CREATE TRIGGER internal_rtb_update
    BEFORE UPDATE
    ON internal_context_on_site_rtb
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 1)
        THEN
        UPDATE context_on_site_rtb
        SET caption = NEW.caption, multistate = NEW.multistate, geo = NEW.geo, mincpm = NEW.mincpm,
            comment = NEW.comment, is_custom_bk_data = NEW.is_custom_bk_data, bk_data = NEW.bk_data,
            media_active = NEW.media_active, media_blocked = NEW.media_blocked, media_cpm = NEW.media_cpm,
            text_active = NEW.text_active, text_blocked = NEW.text_blocked, text_cpm = NEW.text_cpm,
            opts = NEW.opts, horizontal_align = NEW.horizontal_align,
            alternative_code = NEW.alternative_code, blind = NEW.blind, strategy = NEW.strategy,
            active = NEW.active, ex_direct = NEW.ex_direct, duplicate_direct = NEW.duplicate_direct,
            show_video = NEW.show_video, site_version = NEW.site_version, adfox_block = NEW.adfox_block,
            video_active = NEW.video_active, video_blocked = NEW.video_blocked, video_cpm = NEW.video_cpm,
            from_trigger = 2
        WHERE campaign_id = NEW.campaign_id AND id = NEW.id;
    ELSEIF (NEW.from_trigger = 2)
    THEN
        SET NEW.from_trigger = 1;
    END IF;
END; $$
DELIMITER ;

UPDATE
    `internal_context_on_site_rtb`
SET
    `from_trigger` = 1;
