#!/usr/bin/perl
use strict;
use warnings FATAL => 'all';

=head1 пример вызова

    perl -Ilib ./migrations/after_release/PI-26963_update_mobile_app.pl --dry_run
    скрипт актуализации store_id для mobile_app
=cut

use lib::abs qw(../../lib/);

use qbit;
use Utils::ScriptWrapper;
use Utils::CSV;

sub main {
    my ($app, $opts) = @_;
    # my @ids = ();
    my $file_content = readfile("migrations/after_release/PI-26963_mobile_app-store_id.csv");
    for my $block (@{parse_csv($file_content, sep_char => ";")}) {
        # push(@ids, $block->{id});
        $app->mobile_app->partner_db_table->edit($block->{id} => {store_id => $block->{store_id}})
          unless $opts->{dry_run};
    }

    # my $result = $app->mobile_app->partner_db_table->get_all(
    #     fields => [ qw(id store_id multistate type opts) ],
    #     filter => [
    #         AND => [
    #             [ id => 'NOT IN' => \\@ids ],
    #             [multistate => '=' => \4],
    #         ]
    #     ],
    # );
}

sub from_csv {
    my ($header, $filename) = @_;

    my @result;
    return \@result unless -e $filename;

    open F, $filename;
    while (my $str = <F>) {
        $str =~ s/\s+$//;
        my %row;
        @row{@$header} = split /\;/, $str;
        push @result, \%row;
    }
    close F;

    return \@result;
}

sub prepare_args {
    my ($opts) = @_;
    $opts->{ticket} = 'PI-26963';
}

run(\&main);
