ALTER TABLE `mobile_app_rtb`
  DROP FOREIGN KEY `__mobile_app_rtb_ibfk_1`;

ALTER TABLE `mobile_app_rtb`
  DROP PRIMARY KEY,
  ADD PRIMARY KEY (`campaign_id`, `id`),
  ADD FOREIGN KEY `__mobile_app_rtb_ibfk_1` (`campaign_id`)
        REFERENCES `mobile_app_settings` (`context_page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT;

DROP TRIGGER IF EXISTS `external_rtb_insert`;
DELIMITER $$
CREATE TRIGGER external_rtb_insert
    BEFORE INSERT
    ON context_on_site_rtb
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0 AND NEW.model = 'mobile_app_rtb')
    THEN
        SET NEW.from_trigger = 1;
        INSERT INTO mobile_app_rtb (`context_page_id`, `campaign_id`, `adfox_block`, `alternative_code`,
                                    `bk_data`, `block_type`, `caption`, `comment`, `create_date`,
                                    `direct_block`, `geo`, `horizontal_align`, `id`,
                                    `is_custom_bk_data`, `media_active`, `media_block`, `media_blocked`,
                                    `media_cpm`, `mincpm`, `multistate`, `opts`, `place_id`, `show_video`,
                                    `strategy`, `text_active`, `text_blocked`, `text_cpm`, `from_trigger`)
        VALUES (NEW.campaign_id, NEW.campaign_id, NEW.adfox_block, coalesce(NEW.alternative_code,''),
                NEW.bk_data, NEW.block_type, NEW.caption, NEW.comment, NEW.create_date,
                NEW.direct_block, NEW.geo, NEW.horizontal_align, NEW.id,
                NEW.is_custom_bk_data, NEW.media_active, NEW.media_block, NEW.media_blocked,
                NEW.media_cpm, NEW.mincpm, NEW.multistate, NEW.opts, NEW.place_id, NEW.show_video,
                NEW.strategy, NEW.text_active, NEW.text_blocked, NEW.text_cpm, 1);
    END IF;
END; $$
DELIMITER ;

DROP TRIGGER IF EXISTS `external_rtb_update`;
DELIMITER $$
CREATE TRIGGER external_rtb_update
    BEFORE UPDATE
    ON context_on_site_rtb
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 1 AND NEW.model = 'mobile_app_rtb')
        THEN
        UPDATE mobile_app_rtb
        SET
            adfox_block = NEW.adfox_block, alternative_code = NEW.alternative_code,
            bk_data = NEW.bk_data, block_type = NEW.block_type, caption = NEW.caption,
            comment = NEW.comment, create_date = NEW.create_date,
            direct_block = NEW.direct_block, geo = NEW.geo, horizontal_align = NEW.horizontal_align,
            is_custom_bk_data = NEW.is_custom_bk_data, media_active = NEW.media_active, media_block = NEW.media_block,
            media_blocked = NEW.media_blocked, media_cpm = NEW.media_cpm, mincpm = NEW.mincpm, multistate = NEW.multistate,
            opts = NEW.opts, place_id = NEW.place_id, show_video = NEW.show_video, strategy = NEW.strategy,
            text_active = NEW.text_active, text_blocked = NEW.text_blocked, text_cpm = NEW.text_cpm,
            from_trigger = 2
        WHERE campaign_id = NEW.campaign_id AND id = NEW.id;
    ELSEIF (NEW.from_trigger = 2)
    THEN
        SET NEW.from_trigger = 1;
    END IF;
END; $$
DELIMITER ;

LOCK TABLES mobile_app_rtb WRITE;

DROP TRIGGER IF EXISTS `external_mobile_rtb_insert`;
DELIMITER $$
CREATE TRIGGER external_mobile_rtb_insert
    BEFORE INSERT
    ON mobile_app_rtb
    FOR EACH ROW
BEGIN
    DECLARE UNIQUE_ID BIGINT UNSIGNED;
    IF (NEW.from_trigger = 0)
    THEN
        SET NEW.campaign_id = IF(NEW.campaign_id IS NULL, NEW.context_page_id, NEW.campaign_id);
        SET NEW.context_page_id = IF(NEW.context_page_id IS NULL, NEW.campaign_id, NEW.context_page_id);
        SET NEW.from_trigger = 1;
        SET UNIQUE_ID = NEW.id | (NEW.campaign_id << 23) | (2 << 55);
        INSERT INTO context_on_site_rtb (`campaign_id`, `model`, `adfox_block`, `alternative_code`,
                                    `bk_data`, `block_type`, `caption`, `comment`, `create_date`,
                                    `direct_block`, `geo`, `horizontal_align`, `id`,
                                    `is_custom_bk_data`, `media_active`, `media_block`, `media_blocked`,
                                    `media_cpm`, `mincpm`, `multistate`, `opts`, `place_id`, `show_video`,
                                    `strategy`, `text_active`, `text_blocked`, `text_cpm`, `unique_id`, `from_trigger`)
        VALUES (NEW.campaign_id, 'mobile_app_rtb', NEW.adfox_block, coalesce(NEW.alternative_code,''),
                NEW.bk_data, NEW.block_type, NEW.caption, NEW.comment, NEW.create_date,
                NEW.direct_block, NEW.geo, NEW.horizontal_align, NEW.id,
                NEW.is_custom_bk_data, NEW.media_active, NEW.media_block, NEW.media_blocked,
                NEW.media_cpm, NEW.mincpm, NEW.multistate, NEW.opts, NEW.place_id, NEW.show_video,
                NEW.strategy, NEW.text_active, NEW.text_blocked, NEW.text_cpm, UNIQUE_ID, 1);
    END IF;
END; $$
DELIMITER ;

DROP TRIGGER IF EXISTS `external_mobile_rtb_update`;
DELIMITER $$
CREATE TRIGGER external_mobile_rtb_update
    BEFORE UPDATE
    ON mobile_app_rtb
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 1)
        THEN
        UPDATE context_on_site_rtb
        SET
            adfox_block = NEW.adfox_block, alternative_code = NEW.alternative_code,
            bk_data = NEW.bk_data, block_type = NEW.block_type, caption = NEW.caption,
            comment = NEW.comment, create_date = NEW.create_date,
            direct_block = NEW.direct_block, geo = NEW.geo, horizontal_align = NEW.horizontal_align,
            is_custom_bk_data = NEW.is_custom_bk_data, media_active = NEW.media_active, media_block = NEW.media_block,
            media_blocked = NEW.media_blocked, media_cpm = NEW.media_cpm, mincpm = NEW.mincpm, multistate = NEW.multistate,
            opts = NEW.opts, place_id = NEW.place_id, show_video = NEW.show_video, strategy = NEW.strategy,
            text_active = NEW.text_active, text_blocked = NEW.text_blocked, text_cpm = NEW.text_cpm,
            from_trigger = 2
        WHERE campaign_id = NEW.campaign_id AND id = NEW.id;
    ELSEIF (NEW.from_trigger = 2)
    THEN
        SET NEW.from_trigger = 1;
    END IF;
END; $$
DELIMITER ;

UNLOCK TABLES;

UPDATE
    `mobile_app_rtb`
SET
    `from_trigger` = 1
WHERE
    `campaign_id` < 400000;

UPDATE
    `mobile_app_rtb`
SET
    `from_trigger` = 1
WHERE
    `campaign_id` >= 400000;

INSERT IGNORE INTO `context_on_site_rtb` (
    `model`,
    `unique_id`,
    `from_trigger`,
    `campaign_id`,
    `id`,
    `adfox_block`,
    `alternative_code`,
    `bk_data`,
    `block_type`,
    `caption`,
    `comment`,
    `create_date`,
    `direct_block`,
    `geo`,
    `horizontal_align`,
    `is_custom_bk_data`,
    `media_active`,
    `media_block`,
    `media_blocked`,
    `media_cpm`,
    `mincpm`,
    `multistate`,
    `opts`,
    `place_id`,
    `show_video`,
    `strategy`,
    `text_active`,
    `text_blocked`,
    `text_cpm`
)
SELECT
    'mobile_app_rtb' AS `model`,
    `id` | (`campaign_id` << 23) | (2 << 55) AS `unique_id`,
    `from_trigger`,
    `campaign_id`,
    `id`,
    `adfox_block`,
    `alternative_code`,
    `bk_data`,
    `block_type`,
    `caption`,
    `comment`,
    `create_date`,
    `direct_block`,
    `geo`,
    `horizontal_align`,
    `is_custom_bk_data`,
    `media_active`,
    `media_block`,
    `media_blocked`,
    `media_cpm`,
    `mincpm`,
    `multistate`,
    `opts`,
    `place_id`,
    `show_video`,
    `strategy`,
    `text_active`,
    `text_blocked`,
    `text_cpm`
FROM `mobile_app_rtb`;

CREATE OR REPLACE
    VIEW `all_blocks_view` (
                            `adfox_block`,
                            `caption`,
                            `category_id`,
                            `disposition_id`,
                            `id`,
                            `mobile_block_type`,
                            `model`,
                            `multistate`,
                            `page_id`,
                            `place_id`,
                            `site_version`,
                            `video_block_type`
    ) AS
SELECT
    NULL AS `adfox_block`,
    `context_on_site_adblock`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_adblock`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_adblock' AS `model`,
    `context_on_site_adblock`.`multistate` AS `multistate`,
    `context_on_site_adblock`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_adblock`
UNION ALL
SELECT
    `context_on_site_content`.`adfox_block` AS `adfox_block`,
    `context_on_site_content`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_content`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_content' AS `model`,
    `context_on_site_content`.`multistate` AS `multistate`,
    `context_on_site_content`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `context_on_site_content`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_content`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `context_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_direct' AS `model`,
    `context_on_site_direct`.`multistate` AS `multistate`,
    `context_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_direct`
WHERE (
              `context_on_site_direct`.`active` = '1'
          )
UNION ALL
SELECT
    `context_on_site_natural`.`adfox_block` AS `adfox_block`,
    `context_on_site_natural`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_natural`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_natural' AS `model`,
    `context_on_site_natural`.`multistate` AS `multistate`,
    `context_on_site_natural`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `context_on_site_natural`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_natural`
UNION ALL
SELECT
    `context_on_site_rtb`.`adfox_block` AS `adfox_block`,
    `context_on_site_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `context_on_site_rtb`.`id` AS `id`,
    `context_on_site_rtb`.`block_type` AS `mobile_block_type`,
    `context_on_site_rtb`.`model` AS `model`,
    `context_on_site_rtb`.`multistate` AS `multistate`,
    `context_on_site_rtb`.`campaign_id` AS `page_id`,
    `context_on_site_rtb`.`place_id` AS `place_id`,
    `context_on_site_rtb`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_rtb`
WHERE (
              `context_on_site_rtb`.`active` = '1'
          )
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `context_on_site_stripe`.`title` AS `caption`,
    NULL AS `category_id`,
    `context_on_site_stripe`.`disposition_id` AS `disposition_id`,
    `context_on_site_stripe`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'context_on_site_stripe' AS `model`,
    `context_on_site_stripe`.`multistate` AS `multistate`,
    `context_on_site_stripe`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `context_on_site_stripe`
UNION ALL
SELECT
    `internal_context_on_site_content`.`adfox_block` AS `adfox_block`,
    `internal_context_on_site_content`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_context_on_site_content`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_content' AS `model`,
    `internal_context_on_site_content`.`multistate` AS `multistate`,
    `internal_context_on_site_content`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `internal_context_on_site_content`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_content`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_context_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_context_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_direct' AS `model`,
    `internal_context_on_site_direct`.`multistate` AS `multistate`,
    `internal_context_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_direct`
WHERE (
              `internal_context_on_site_direct`.`active` = '1'
          )
UNION ALL
SELECT
    `internal_context_on_site_natural`.`adfox_block` AS `adfox_block`,
    `internal_context_on_site_natural`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_context_on_site_natural`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_natural' AS `model`,
    `internal_context_on_site_natural`.`multistate` AS `multistate`,
    `internal_context_on_site_natural`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    `internal_context_on_site_natural`.`site_version` AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_natural`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_context_on_site_stripe`.`title` AS `caption`,
    NULL AS `category_id`,
    `internal_context_on_site_stripe`.`disposition_id` AS `disposition_id`,
    `internal_context_on_site_stripe`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_context_on_site_stripe' AS `model`,
    `internal_context_on_site_stripe`.`multistate` AS `multistate`,
    `internal_context_on_site_stripe`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_context_on_site_stripe`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_mobile_app_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_mobile_app_rtb`.`id` AS `id`,
    `internal_mobile_app_rtb`.`block_type` AS `mobile_block_type`,
    'internal_mobile_app_rtb' AS `model`,
    `internal_mobile_app_rtb`.`multistate` AS `multistate`,
    `internal_mobile_app_rtb`.`application_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_mobile_app_rtb`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_search_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_search_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_search_on_site_direct' AS `model`,
    `internal_search_on_site_direct`.`multistate` AS `multistate`,
    `internal_search_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_search_on_site_direct`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `internal_search_on_site_premium`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `internal_search_on_site_premium`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'internal_search_on_site_premium' AS `model`,
    `internal_search_on_site_premium`.`multistate` AS `multistate`,
    `internal_search_on_site_premium`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `internal_search_on_site_premium`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `search_on_site_direct`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `search_on_site_direct`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'search_on_site_direct' AS `model`,
    `search_on_site_direct`.`multistate` AS `multistate`,
    `search_on_site_direct`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `search_on_site_direct`
UNION ALL
SELECT
    NULL AS `adfox_block`,
    `search_on_site_premium`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `search_on_site_premium`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'search_on_site_premium' AS `model`,
    `search_on_site_premium`.`multistate` AS `multistate`,
    `search_on_site_premium`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `search_on_site_premium`
UNION ALL
SELECT
    `ssp_context_on_site_rtb`.`adfox_block` AS `adfox_block`,
    `ssp_context_on_site_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `ssp_context_on_site_rtb`.`id` AS `id`,
    `ssp_context_on_site_rtb`.`block_type` AS `mobile_block_type`,
    'ssp_context_on_site_rtb' AS `model`,
    `ssp_context_on_site_rtb`.`multistate` AS `multistate`,
    `ssp_context_on_site_rtb`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `ssp_context_on_site_rtb`
UNION ALL
SELECT
    `ssp_mobile_app_rtb`.`adfox_block` AS `adfox_block`,
    `ssp_mobile_app_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `ssp_mobile_app_rtb`.`id` AS `id`,
    `ssp_mobile_app_rtb`.`block_type` AS `mobile_block_type`,
    'ssp_mobile_app_rtb' AS `model`,
    `ssp_mobile_app_rtb`.`multistate` AS `multistate`,
    `ssp_mobile_app_rtb`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `ssp_mobile_app_rtb`
UNION ALL
SELECT
    `ssp_video_an_site_rtb`.`adfox_block` AS `adfox_block`,
    `ssp_video_an_site_rtb`.`caption` AS `caption`,
    NULL AS `category_id`,
    NULL AS `disposition_id`,
    `ssp_video_an_site_rtb`.`id` AS `id`,
    `ssp_video_an_site_rtb`.`block_type` AS `mobile_block_type`,
    'ssp_video_an_site_rtb' AS `model`,
    `ssp_video_an_site_rtb`.`multistate` AS `multistate`,
    `ssp_video_an_site_rtb`.`campaign_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    NULL AS `video_block_type`
FROM `ssp_video_an_site_rtb`
UNION ALL
SELECT
    `video_an_site_fullscreen`.`adfox_block` AS `adfox_block`,
    `video_an_site_fullscreen`.`caption` AS `caption`,
    `video_an_site_fullscreen`.`category_id` AS `category_id`,
    NULL AS `disposition_id`,
    `video_an_site_fullscreen`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'video_an_site_fullscreen' AS `model`,
    `video_an_site_fullscreen`.`multistate` AS `multistate`,
    `video_an_site_fullscreen`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    `video_an_site_fullscreen`.`type` AS `video_block_type`
FROM `video_an_site_fullscreen`
UNION ALL
SELECT
    `video_an_site_inpage`.`adfox_block` AS `adfox_block`,
    `video_an_site_inpage`.`caption` AS `caption`,
    `video_an_site_inpage`.`category_id` AS `category_id`,
    NULL AS `disposition_id`,
    `video_an_site_inpage`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'video_an_site_inpage' AS `model`,
    `video_an_site_inpage`.`multistate` AS `multistate`,
    `video_an_site_inpage`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    `video_an_site_inpage`.`type` AS `video_block_type`
FROM `video_an_site_inpage`
UNION ALL
SELECT
    `video_an_site_instream`.`adfox_block` AS `adfox_block`,
    `video_an_site_instream`.`caption` AS `caption`,
    `video_an_site_instream`.`category_id` AS `category_id`,
    NULL AS `disposition_id`,
    `video_an_site_instream`.`id` AS `id`,
    NULL AS `mobile_block_type`,
    'video_an_site_instream' AS `model`,
    `video_an_site_instream`.`multistate` AS `multistate`,
    `video_an_site_instream`.`page_id` AS `page_id`,
    NULL AS `place_id`,
    NULL AS `site_version`,
    `video_an_site_instream`.`type` AS `video_block_type`
FROM `video_an_site_instream`;

UPDATE
    `kv_store`
SET
    `value` = JSON_SET(`value`, '$.mobile_app_rtb', true)
WHERE
    `key` = 'use_common_blocks_table';
