UPDATE users u,
  (SELECT CASE
           WHEN ap.user_id IS NULL THEN 0
           ELSE 1
         END AS app,
         CASE
           WHEN st.user_id IS NULL THEN 0
           ELSE 1
         END AS site,
         u.id
  FROM users u
    LEFT JOIN (SELECT DISTINCT ao.user_id
               FROM mobile_app_action_log al
                 JOIN mobile_app_owner ao ON ao.app_id = al.elem_id
               WHERE action = 'approve') ap ON u.id = ap.user_id
    LEFT JOIN (SELECT DISTINCT so.user_id
               FROM site_action_log sl
                 JOIN owner_site so ON so.domain_id = sl.elem_id
               WHERE sl.action = 'approve') st ON u.id = st.user_id
  ) data
SET u.opts = json_set (u.opts,'$.has_approved_site',site,'$.has_approved_app',app)
WHERE data.id = u.id and u.opts->>'$.has_approved_site' is null;
