INSERT IGNORE INTO
    `simple_notification`
SET
    `button_text_en` = 'Add a website',
    `button_text_ru` = 'Добавить сайт',
    `link`           = '/v2/context/campaigns/',
    `message_en`     = 'After adding the site, it will automatically go for moderation. Read more about the moderation process in the <A href="https://yandex.ru/support/partner/joining/moderation.html?lang=en" target="_blank">Help</A>.',
    `message_ru`     = 'После добавления сайт автоматически отправится на модерацию. Подробнее о процессе модерации читайте в <A href="https://yandex.ru/support/partner/joining/moderation.html?lang=ru" target="_blank">Справке</A>.',
    `multistate`     = 0,
    `ntype`          = 'action_banner',
    `short_name`     = 'welcome_web',
    `title_en`       = 'Add a site that you plan to monetize',
    `title_ru`       = 'Добавьте сайт, который планируете монетизировать';


INSERT IGNORE INTO
    `simple_notification`
SET
    `button_text_en` = 'Add an app',
    `button_text_ru` = 'Добавить приложение',
    `link`           = '/v2/inapp/',
    `message_en`     = 'After the app is added, it will automatically go for moderation. Read more about the moderation process in the <A href="https://yandex.ru/support/partner/joining/moderation.html?lang=en" target="_blank">Help</A>.',
    `message_ru`     = 'После добавления приложение автоматически отправится на модерацию. Подробнее о процессе модерации читайте в <A href="https://yandex.ru/support/partner/joining/moderation.html?lang=ru" target="_blank">Справке</A>.',
    `multistate`     = 0,
    `ntype`          = 'action_banner',
    `short_name`     = 'welcome_mobile',
    `title_en`       = 'Add the application that you plan to monetize',
    `title_ru`       = 'Добавьте приложение, которое планируете монетизировать';


UPDATE
    `simple_notification`
SET
    `title_en`   = 'Enter your payment details',
    `title_ru`   = 'Внесите свои платёжные реквизиты',
    `message_en` = 'If your resource has passed moderation, fill out a questionnaire with payment details so that we can transfer the reward to you. The payment takes place after the acceptance of the offer by Yandex and the payment threshold is reached. Read more about payments in the <A href="https://yandex.ru/support/partner/joining/moderation.html?lang=en" target="_blank">Help</A>.',
    `message_ru` = 'Если ваш ресурс прошел модерацию, заполните анкету с платёжными реквизитами, чтобы мы могли перечислять вам вознаграждение. Выплата происходит после акцепта оферты со стороны Яндекса и достижения порога выплат. Подробнее о выплатах читайте в <A href="https://yandex.ru/support/partner/joining/moderation.html?lang=ru" target="_blank">Справке</A>.'
WHERE
    `short_name` IN ('fill_requisites', 'fill_requisites_games');


INSERT IGNORE INTO
    `simple_notification_roles`
SELECT
    `id` AS `notification_id`,
    9    AS `role_id`
FROM
    `simple_notification`
WHERE
    `short_name` = 'welcome_web';


INSERT IGNORE INTO
    `simple_notification_roles`
SELECT
    `id` AS `notification_id`,
    27   AS `role_id`
FROM
    `simple_notification`
WHERE
    `short_name` = 'welcome_mobile';
