#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

нужно подключить прод базу ПИ2 и в конфигах прописать нужные настройки для конекта к базе ПИ1

время работы ~ 14s

=cut

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;

use URI;
use HTTP::Tiny;
use XML::Simple;

main();

sub main {
    my $app = Application->new();

    $app->pre_run();

    $app->set_option('cur_user' => {id => 0});    #cron

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    set_yandex_xml_product($app);

    $app->post_run();
}

sub set_yandex_xml_product {
    my ($self) = @_;

    $self->migration->connect_to_db_pi();

    my %data =
      map {$_->{'bs_page'} => $_} @{
        $self->migration->get_data_from_partner1_database(
            "select bs_page, uid, multistate from campaigns where xml = 1")
      };

    my %campaigns = map {$_->{'page_id'} => $_} @{
        $self->search_on_site_campaign->get_all(
            fields => [qw(id page_id owner_id)],
            filter => {page_id => [keys(%data)]}
        )
      };

    my %tutby_partners =
      map {$_->{'uid'} => TRUE} @{
        $self->migration->get_data_from_partner1_database(
            "SELECT u.uid
FROM users u
WHERE
    u.login IS NOT NULL
AND
    u.login NOT IN ('m-ru-text')
AND
    COALESCE(u.go_away_now_type, '') = ''
AND
    u.multistate IN ('BEG_3','BEG_15','BEG_16')
AND
    u.uid NOT IN (SELECT id FROM _aggr_dict)
AND
    u.uid NOT IN (SELECT fake_id FROM _aggr_dict
        WHERE fake_id IS NOT NULL)
AND
    (
        COALESCE(u.citizenship, '') = 4
            AND COALESCE(u.cooperationtype, 0) = 2
            AND COALESCE(u.type, '') = ''
    )
GROUP BY u.uid;"
        )
      };

    my @not_found = ();
    foreach my $page_id (grep {!$campaigns{$_}} keys(%data)) {
        next if $tutby_partners{$data{$page_id}->{'uid'}};

        next if $data{$page_id}->{'multistate'} =~ /BS_BLACK|BS_ARCH|BS_STOP|BST_ARCH/;

        push(@not_found, $page_id)
          unless $data{$page_id}->{'multistate'} =~ /BS_WORK_|BST_WORK_|BSM_WORK_|BS_\d+_WORK_/;
    }

    throw sprintf("Page not found(%s): %s\n", scalar(@not_found), join(', ', @not_found))
      if @not_found;

    foreach (keys(%campaigns)) {
        throw "difference users: PI1 = $data{$_}->{uid}, PI2 = $campaigns{$_}->{'owner_id'}"
          if $data{$_}->{'uid'} != $campaigns{$_}->{'owner_id'};
    }

    $self->partner_db->search_on_site_campaign->edit($self->partner_db->filter({page_id => [keys(%campaigns)]}),
        {yandex_xml => 1});
}
