#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

Нужно подключить ПРОД БАЗУ

Время работы:

    real    24m53.770s

=cut

# project modules
use lib::abs qw(
  ../lib
  );
use qbit;
use Application;
use Utils::XLS;

use Spreadsheet::ParseExcel;

my $DIR = './PI-8700_xls';
my $APP;

main();

sub main {
    $APP = Application->new();

    $APP->pre_run();

    mkdir $DIR;

    fix_money();

    $APP->post_run();
}

sub fix_money {
    my $tmp_rights =
      $APP->add_tmp_rights('video_stat_files_view_all', 'video_stat_files_edit', 'video_stat_files_edit_all');

    my $stat_files = $APP->video_stat_files->get_all(
        fields   => [qw(id uncompress_data modification_date)],
        filter   => ['AND', [{type => 'archive'}, ['date', '>=', '2016-04-01']]],
        order_by => ['id'],
    );

    my $fields = $APP->video_stat_files->get_fields_for_xls();

    foreach my $f (@$stat_files) {
        #next if $f->{'id'} < ERROR_ID;

        print "fix file $f->{'id'}\n";

        writefile("$DIR/$f->{'id'}.xls", $f->{'uncompress_data'}, binary => TRUE);

        my $parser   = Spreadsheet::ParseExcel->new();
        my $workbook = $parser->parse("$DIR/$f->{'id'}.xls");

        my ($worksheet) = $workbook->worksheets();

        my ($row_min, $row_max) = $worksheet->row_range();

        my @stat = ();
        foreach my $row (($row_min + 1 .. $row_max)) {
            my $data = {};
            my $col  = 0;
            foreach (@$fields) {
                my $cell = $worksheet->get_cell($row, $col);

                $data->{$_->{'field'}} = $cell->value();

                $col++;
            }

            foreach (("bk_partner_price_w_nds", "bk_partner_price_wo_nds")) {
                $data->{$_} = length($data->{$_}) >= 8 ? $APP->video_stat_files->money2float($data->{$_}) : 0;
            }

            push(@stat, $data);
        }

        my $xls_binary = xls_with_fields_and_names(\@stat, $fields);

        $APP->video_stat_files->edit(
            $f->{'id'},
            data              => $xls_binary,
            modification_date => $f->{'modification_date'}
        );
    }
}
