#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

=cut

# common modules
use feature 'say';
use Carp;

# project modules
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

# global vars

# subs

# main
sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 0});
    no strict 'refs';
    no warnings 'redefine';
    *{'QBit::Application::check_rights'} = sub {TRUE};

    my $model_fields = $app->internal_context_on_site_direct->get_model_fields();

    my $blocks = $app->internal_context_on_site_direct->get_all(fields => [keys(%$model_fields)],);

    foreach my $block (@{$blocks}) {

        next if $block->{id} eq '0';

        my $partner_share = $app->internal_context_on_site_direct->get_dsp_partner_share($block->{campaign_id});
        my $article_tree  = $app->internal_context_on_site_direct->tns_dict_article->get_real_article_tree();

        my $bk_data = $app->internal_context_on_site_direct->get_bk_block_data($block, $partner_share, $article_tree);

        my $bk_data_json = to_json($bk_data, pretty => 1);

        if (not defined $block->{bk_data}) {

            warn to_json(
                {
                    page_id  => $block->{campaign_id},
                    block_id => $block->{id},
                    what     => 'setting bk_data',
                }
            ) . "\n";

            $app->partner_db->_get_all(
                SQL::Abstract->new(quote_char => '`')->update(
                    'internal_context_on_site_direct',
                    {bk_data => $bk_data_json,},
                    {
                        campaign_id => $block->{campaign_id},
                        id          => $block->{id},
                    },
                ),
            );

        } else {
            if ($bk_data_json ne $block->{bk_data}) {
                die sprintf("WARNING!!! bk_data is incorrrect Page ID %s Block ID %s",
                    $block->{campaign_id}, $block->{id});
            }
        }

    }

    warn "#END\n";

    $app->post_run();
}
main();
__END__
