#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

use lib::abs qw(../../lib/);
use feature say;
use qbit;
use Application;
use File::Temp qw(tempfile);

my $APP;

main();

sub main {

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    $APP = Application->new();

    $APP->pre_run();

    resend_apps();

    $APP->post_run();
}

sub resend_apps {
    my @app_ids =
      map {$_->{id}}
      @{$APP->internal_mobile_app->get_all(fields => [qw(id)], filter => {multistate => 'not protected'})};

    my ($page_ids_fh, $page_ids_file_name) = tempfile('PI_9302_after_release_page_ids_XXXXXX', TMPDIR => 1);
    my (undef, $log_file_name) = tempfile('PI_9302_after_release_log_XXXXXX', OPEN => 0, TMPDIR => 1);

    $page_ids_fh->print(join("\n", @app_ids));
    close($page_ids_fh);

    say "resend_to_bk.pl input file: $page_ids_file_name";
    say "resend_to_bk.pl log file: $log_file_name";

    my $system_string = "perl bin/resend_to_bk.pl --file_path=$page_ids_file_name 1>>$log_file_name 2>>$log_file_name";

    say "Starting system('$system_string')";

    system($system_string);

    say 'END';
}
