#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
=cut

use lib::abs qw(../../lib/);
use feature say;
use qbit;
use Application;
use File::Temp qw(tempfile);

my $APP;

main();

sub main {

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    $APP = Application->new();

    $APP->pre_run();

    resend_apps();

    $APP->post_run();
}

sub resend_apps {
    my $ignore_pages = $APP->partner_db->all_pages_view->get_all(
        fields => [qw(page_id)],
        filter => [
            'AND',
            [
                ['page_id', 'IS NOT', undef],
                [
                    'owner_id',
                    'IN',
                    \[
                        265217053,    #vk-rsya
                        363072506,    #vk-rsya-apps
                        34027711,     #wwwodnoklassniki
                        301147605,    #wwwodnoklassniki-2015
                        120143188,    #rambler-p
                        217912896,    #gomailru-ads
                        301137679,    #m-ru-2015
                        28166288,     #m-ru-text
                     ]
                ]
            ]
        ]
    );

    my @inore_page_ids = map {$_->{'page_id'}} @$ignore_pages;

    my %page_ids = ();

    foreach my $accessor (qw(context_on_site_rtb context_on_site_adfox internal_context_on_site_rtb)) {
        my $direct_blocks =
          [map {$_->{'id'}} grep {$_->{'id'} =~ /^\d+x\d+$/} @{$APP->$accessor->get_types_direct_blocks()}];

        my $query = $APP->partner_db->query->select(
            table  => $APP->partner_db->$accessor,
            fields => [qw(campaign_id)],
            filter => [
                'AND',
                [
                    ['multistate',    'IN',     \$APP->$accessor->get_multistates_by_filter('not deleted')],
                    ['media_blocked', '=',      \1],
                    ['direct_block',  'IN',     \$direct_blocks],
                    ['campaign_id',   'NOT IN', \\@inore_page_ids]
                ]
            ]
        );

        $page_ids{$_->{'campaign_id'}} = 1 foreach @{$query->get_all()};
    }

    my ($page_ids_fh, $page_ids_file_name) = tempfile('PI_9665_view_smart_XXXXXX', DIR => './');
    my (undef, $log_file_name) = tempfile('PI_9665_view_smart_log_XXXXXX', OPEN => 0, DIR => './');

    $page_ids_fh->print(join("\n", sort keys(%page_ids)));
    close($page_ids_fh);

    say "resend_to_bk.pl input file: $page_ids_file_name";
    say "resend_to_bk.pl log file: $log_file_name";

    my $system_string = "perl bin/resend_to_bk.pl --file_path=$page_ids_file_name 1>>$log_file_name 2>>$log_file_name";

    say "Starting system('$system_string')";

    system($system_string);

    say 'END';
}
