set @CAMPAIGNS_RTB = (select group_concat(distinct campaign_id) from context_on_site_rtb where isnull(horizontal_align));
set @CAMPAIGNS_ADFOX = (select group_concat(distinct campaign_id) from context_on_site_adfox where isnull(horizontal_align));
set @CAMPAIGNS_INTRTB = (select group_concat(distinct campaign_id) from internal_context_on_site_rtb where isnull(horizontal_align));

update context_on_site_rtb set horizontal_align = 1 where isnull(horizontal_align);
update context_on_site_adfox set horizontal_align = 1 where isnull(horizontal_align);
update internal_context_on_site_rtb set horizontal_align = 1 where isnull(horizontal_align);

set sql_mode='STRICT_TRANS_TABLES';

ALTER TABLE context_on_site_rtb MODIFY COLUMN `horizontal_align` tinyint(1) NOT NULL DEFAULT '1', ALGORITHM=INPLACE, LOCK=NONE;
ALTER TABLE context_on_site_adfox MODIFY COLUMN `horizontal_align` tinyint(1) NOT NULL DEFAULT '1', ALGORITHM=INPLACE, LOCK=NONE;
ALTER TABLE internal_context_on_site_rtb MODIFY COLUMN `horizontal_align` tinyint(1) NOT NULL DEFAULT '1', ALGORITHM=INPLACE, LOCK=NONE;

ANALYZE TABLE context_on_site_rtb;
ANALYZE TABLE context_on_site_adfox;
ANALYZE TABLE internal_context_on_site_rtb;

# set need_update if not (need_approve or rejected or deleted or protected)
select page_id,multistate from context_on_site_campaign where find_in_set(page_id, @CAMPAIGNS_RTB) and not (multistate & 256 || multistate & 512 || multistate & 8 || multistate & 1024);
update context_on_site_campaign set multistate = multistate | 2048 where find_in_set(page_id, @CAMPAIGNS_RTB) and not (multistate & 256 || multistate & 512 || multistate & 8 || multistate & 1024);
select page_id,multistate from context_on_site_campaign where find_in_set(page_id, @CAMPAIGNS_RTB) and not (multistate & 256 || multistate & 512 || multistate & 8 || multistate & 1024);

# set need_update if not (need_approve or rejected or deleted or protected)
select page_id,multistate from context_on_site_campaign where find_in_set(page_id, @CAMPAIGNS_ADFOX) and not (multistate & 256 || multistate & 512 || multistate & 8 || multistate & 1024);
update context_on_site_campaign set multistate = multistate | 2048 where find_in_set(page_id, @CAMPAIGNS_ADFOX) and not (multistate & 256 || multistate & 512 || multistate & 8 || multistate & 1024);
select page_id,multistate from context_on_site_campaign where find_in_set(page_id, @CAMPAIGNS_ADFOX) and not (multistate & 256 || multistate & 512 || multistate & 8 || multistate & 1024);

# set need_update if not (deleted or protected)
select page_id,multistate from context_on_site_campaign where find_in_set(id, @CAMPAIGNS_INTRTB) and not (multistate & 8 || multistate & 128);
update internal_context_on_site_campaign set multistate = multistate | 256 where find_in_set(id, @CAMPAIGNS_INTRTB) and not (multistate & 8 || multistate & 128);
select page_id,multistate from context_on_site_campaign where find_in_set(id, @CAMPAIGNS_INTRTB) and not (multistate & 8 || multistate & 128);
