#!/usr/bin/perl

=encoding UTF-8
=cut

use strict;
use warnings;
use utf8;

use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

=head1 Скрипт изменяет таблицы

    Скрипт изменяет поля form_factor в таблицах
    context_on_site_rtb и internal_context_on_site_rtb

=cut

my $app = Application->new();
$app->pre_run();

my $script = lib::abs::path('../../bin/pt-online-schema-change.pl');

foreach my $table (qw(context_on_site_rtb internal_context_on_site_rtb)) {
    system($script, "--table=$table",
"--alter=CHANGE COLUMN `form_factor` `form_factor` ENUM('horizontal', 'vertical') DEFAULT 'vertical', CHANGE COLUMN `smart_media` `smart_media` TINYINT(1) DEFAULT '1'"
    );

    $app->partner_db->_do("ANALYZE TABLE `partner`.`$table`;");

    $app->partner_db->_do("UPDATE `partner`.`$table` set `form_factor` = null WHERE `form_factor` = '';");
}

print "#END\n";
