#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION

    нужно подключить прод базу и БК

=cut

use lib::abs qw(../../lib/);
use feature say;
use qbit;
use Application;
use File::Temp qw(tempfile);

my $APP;

main();

sub main {

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    $APP = Application->new();

    $APP->pre_run();

    resend_apps();

    $APP->post_run();
}

sub resend_apps {
    my %page_ids = ();

    foreach my $accessor (
        qw(context_on_site_adfox context_on_site_rtb mobile_app_rtb internal_context_on_site_rtb internal_mobile_app_rtb)
      )
    {
        my $page_id_name = $APP->$accessor->get_page_id_field_name();

        my $data = $APP->partner_db->$accessor->get_all(
            fields => [$page_id_name],
            filter => [
                'AND',
                [
                    ['multistate',   'IN', \$APP->$accessor->get_multistates_by_filter('not deleted')],
                    ['direct_block', '=',  \'vertical'],
                ]
            ]
        );

        $page_ids{$_->{$page_id_name}} = 1 foreach @$data;
    }

    my ($page_ids_fh, $page_ids_file_name) = tempfile('PI-10010_callouts_for_vertical_XXXXXX', DIR => './');
    my (undef, $log_file_name) = tempfile('PI-10010_callouts_for_vertical_log_XXXXXX', OPEN => 0, DIR => './');

    $page_ids_fh->print(join("\n", sort keys(%page_ids)));
    close($page_ids_fh);

    say "resend_to_bk.pl input file: $page_ids_file_name";
    say "resend_to_bk.pl log file: $log_file_name";

    my $system_string = "perl bin/resend_to_bk.pl --file_path=$page_ids_file_name 1>>$log_file_name 2>>$log_file_name";

    say "Starting system('$system_string')";

    system($system_string);

    say '#END';
}
